#include <allegro.h>
#include <iostream>

#include "main.h"

#define RIGHT 3 // move in each direction 
#define LEFT 3 
#define UP 3 
#define DOWN 3
#define BD 22 //ball diameter
 
BITMAP *character, *rose, *heart; 
BITMAP *ball1, *ball2, *ball3, *ball4;
BITMAP *buffer; 
SAMPLE *hit, *gotit, *boing, *cheer;
MIDI *music;

PacSmiley_t Pac;    // our hero       
ball_t b1, b2, b3, b4;  // enemy balls
flower_t flower;    // item to collect
heart_t hrt;

short collision;
short temp, rolledover1, rolledover2, rolledover3, rolledover4;

// variables used for timing the heart pop up
//volatile int elapsed_seconds;


int main() 
 {
   // setup Allegro
   setup();

   allegro_message("PacSmiley v.1.0 \n\n Arrow keys move PacSmiley, Esc quits \n\n Click OK to start!");   
   
   // starting game values
   initgame();
 
   // main game loop
   gameloop();
  
 return 0;
 }

END_OF_MAIN();

void setup() 
 {
   allegro_init(); //initializes allegro
   install_keyboard(); //installs the keyboard routines
   install_timer();
   install_sound (DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
   
   // setting up the timer
   //LOCK_VARIABLE(elapsed_seconds);
   //LOCK_FUNCTION(increment_seconds);
   //install_int_ex(increment_seconds, SECS_TO_TIMER(1));

   // load music samples
   hit = load_sample("ouch.wav");
   gotit = load_sample("applause.wav");
   boing = load_sample("boing.wav");
   cheer = load_sample("cheer.wav");
   
   music = load_midi("rachb.mid");
   
   if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0) < 0) 
   {
	allegro_message("Couldn't set gfx mode: %s\n", allegro_error);
	exit(1);
    }
  
   buffer = create_bitmap(SCREEN_W, SCREEN_H); //creating the buffer as the same size as the screen
   character = load_bitmap("pacsmiley.bmp", NULL); //loading the PacSmiley bitmap
   ball1 = load_bitmap("ball.bmp", NULL); //loading the ball bitmap
   ball2 = load_bitmap("ball.bmp", NULL);
   ball3 = load_bitmap("ball.bmp", NULL); 
   ball4 = load_bitmap("ball.bmp", NULL); 
   rose = load_bitmap("flower.bmp", NULL); // loading the flower    
   heart = load_bitmap("heart.bmp", NULL);
   
   // transparent text background
   text_mode(-1); 
                 
   clear(screen);
 }

void shutdown() 
 {
   // let's clean up  
//   clear_keybuf();
//   destroy_bitmap(buffer);
//   destroy_bitmap(ball1);   
//   destroy_bitmap(ball2);
//   destroy_bitmap(ball3);
//   destroy_bitmap(ball4);
//   destroy_bitmap(character);
//   destroy_bitmap(rose);
//   destroy_sample(hit);
//   destroy_sample(gotit);
//   destroy_sample(boing);
   
   // this one should automatically do all of the above
   allegro_exit();
 }

void redraw() 
 {  
   short popup;  
        
   clear_bitmap(buffer); //clearing the buffer
   clear_to_color(buffer, 15); // white background

   // if the flower has been taken, redraw it in a different position
   if (flower.flag == 1)
   {
      flower.flag = 0;
      flower.x = rand() % SCREEN_W;
      
      // avoid the borders
      if (flower.x < 30)
         flower.x = 30; 
      else if (flower.x > SCREEN_W - 40)
        flower.x = SCREEN_W - 40;
        
      flower.y = rand() % SCREEN_H;
      if (flower.y < 30)
         flower.y = 30; 
      else if (flower.y > SCREEN_H - 40)
        flower.y = SCREEN_H - 40;   
   }    
   
   //drawing the sprites to the buffer
   
   // eventually draw a heart for giving extra life
   popup = rand() % SCREEN_W; 
   if ((popup % 300) == 0)
   {
      hrt.x = rand() % SCREEN_W;
      hrt.y = rand() % SCREEN_H;                 
   }
   
   draw_sprite(buffer, heart, hrt.x, hrt.y);
   
   draw_sprite(buffer, rose, flower.x, flower.y); 
   draw_sprite(buffer, character, Pac.x, Pac.y); 
   draw_sprite(buffer, ball1, b1.x, b1.y); 
   draw_sprite(buffer, ball2, b2.x, b2.y);
   draw_sprite(buffer, ball3, b3.x, b3.y);
   draw_sprite(buffer, ball4, b4.x, b4.y);

   textprintf(buffer, font, 0, 0, 0, "Score: %d    Lives: %d", Pac.score, Pac.lives);
  
   // using double buffering    
   vsync();  
   blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H); //blitting the buffer to the screen so you can see everything
 }
 
 void moveballs(ball_t *b)
 {
    if (b->x >= SCREEN_W-BD || b->x <= 0)
       {
         // change direction    
         b->xd = -1 * b->xd;
       }
    b->x = b->x + b->xs * b->xd; 
             
    if (b->y >= SCREEN_H-BD || b->y <= 0)
    {
         b->yd = -1 * b->yd;
     }
    b->y = b->y + b->ys * b->yd;    
 }
 
 short bounce(ball_t a, ball_t b)
 {
   short hit;
   
   hit = 0;
       
   if ((a.x >= b.x-15) && (a.x <= b.x+15) && (a.y >= b.y-15) && (a.y <= b.y+15)) 
     {  
       hit = 1;   
     }
    
   if (hit == 1)
   {  
       // now let's play a 2D sound!
       if (a.x >= SCREEN_W*2/3) //play mostly on the right
          play_sample (boing, 255, 240, 1000, 0);
       else if (a.x <= SCREEN_W/3) // play on the left
          play_sample (boing, 255, 15, 1000, 0);
       else // play in the middle
          play_sample (boing, 255, 128, 1000, 0);
    }
    return (hit); 
 }
 
 short pachit(PacSmiley_t pac, ball_t b)
   {
   short kill;
   
   kill = 0;
       
   if ((pac.x >= b.x-15) && (pac.x <= b.x+15) && (pac.y >= b.y-15) && (pac.y <= b.y+15)) 
     {  
       kill = 1;  
     }
 
    return (kill); 
 }
 
 void initgame()
 {
        // player starting position (middle of the screen) and score
   Pac.x = SCREEN_W / 2;
   Pac.y = SCREEN_H / 2;
   Pac.score = 0;
   Pac.lives = 1;
   collision = 0;
   
   //elapsed_seconds = 1;
   
   // by default the heart is invisible i.e. out of the window
     hrt.x = -50;
     hrt.y = -50;
     hrt.gain = 1;
   
   srand(time(NULL));
   
   // setting initial ball speed (module and direction) and position
   b1.xs = 5;
   b1.ys = 5;
   b1.xd = 1;
   b1.yd = 1;
   b1.x = rand() % SCREEN_W; 
   b1.y = rand() % SCREEN_H;  

   b2.xs = 4;
   b2.ys = 4;
   b2.xd = 1;
   b2.yd = -1;
   b2.x = rand() % SCREEN_W; 
   b2.y = rand() % SCREEN_H;  

   b3.xs = 3;
   b3.ys = 3;
   b3.xd = -1;
   b3.yd = 1;
   b3.x = rand() % SCREEN_W; 
   b3.y = rand() % SCREEN_H;  
 
   b4.xs = 2;
   b4.ys = 2;
   b4.xd = -1;
   b4.yd = -1;
   b4.x = rand() % SCREEN_W; 
   b4.y = rand() % SCREEN_H; 
   
   // flower starting data
   flower.x = rand() % SCREEN_W; 
   flower.y = rand() % SCREEN_H; 
   flower.flag = 0; // flower not taken
      
   rolledover1 = 0;
   rolledover2 = 0;
   rolledover3 = 0;   
   rolledover4 = 0;
       
   // start playing music!
   play_midi (music, 1);
   
   redraw();
}

void gameloop()
{
   // main game loop
   while(!key[KEY_ESC] && Pac.lives > 0) //while Esc key isn't pressed or gameover
    //while (Pac.lives > 0)
    {       
        // compute new ball coordinates     
        //getballxy();        
          moveballs(&b1);
          moveballs(&b2);
          moveballs(&b3);
          moveballs(&b4);
                            
         if (key[KEY_RIGHT] && (Pac.x + RIGHT < SCREEN_W-20))
          Pac.x += RIGHT;
         else if (key[KEY_LEFT] && (Pac.x - LEFT > 0))
          Pac.x -= LEFT;
         else if (key[KEY_UP] && (Pac.y - UP > 0))
          Pac.y -= UP;
         else if (key[KEY_DOWN] && (Pac.y + DOWN < SCREEN_H-20))
          Pac.y += DOWN;
     
     //check for collisions
      //printf("Pac: X:%d Y:%d    Rose: X:%d Y:%d \n", Pac.x, Pac.y, flower.x, flower.y);   
     
     // PacSmiley / Flower collision: increment score and display another flower
     if ((Pac.x >= flower.x-10) && (Pac.x <= flower.x+10) && (Pac.y >= flower.y-10) && (Pac.y <= flower.y+10)) 
        {
                  Pac.score++;
                  flower.flag = 1;
                  play_sample (gotit, 255, 128, 1000, 0);
        } 
     // PacSmiley / Heart collision
     if ((Pac.x >= hrt.x-10) && (Pac.x <= hrt.x+10) && (Pac.y >= hrt.y-10) && (Pac.y <= hrt.y+10)) 
        {
                  Pac.lives++;
                  hrt.x = -50;
                  hrt.y = -50;
                  play_sample (cheer, 255, 128, 1000, 0);
        }    
   
     // ball / ball collision: change all directions
     collision = bounce(b1, b2);
     if (collision == 1)
     {
        changedir(&b1,&b2);                   
     }
     
     collision = bounce(b1, b3);
     if (collision == 1)
     {
         changedir(&b1,&b3);             
     }
 
     collision = bounce(b2, b3);
     if (collision == 1)
     {
         changedir(&b2,&b3);           
     }
     
     collision = bounce(b2, b4);
     if (collision == 1)
     {
         changedir(&b2,&b4);                       
     }     
     
     collision = bounce(b1, b4);
     if (collision == 1)
     {
         changedir(&b1,&b4);           
     }       
 
     collision = bounce(b3, b4);
     if (collision == 1)
     {
         changedir(&b3,&b4);                       
     }  
       
     // PacSmiley / ball collision: lose a life or Game Over!
     rolledover1 = pachit(Pac, b1);
     rolledover2 = pachit(Pac, b2);
     rolledover3 = pachit(Pac, b3);
     rolledover4 = pachit(Pac, b4);
     
     // if Pac is "rolled over" by a ball, it looses a life 
     // and gets a different position
     
     if (rolledover1 == 1 || rolledover2 == 1 || rolledover3 == 1 || rolledover4 ==1)
     {
        Pac.lives--;
        play_sample (hit, 255, 128, 1000, 0);
        Pac.x = rand() % SCREEN_W; 
        Pac.y = rand() % SCREEN_H; 
      }
                
      redraw();
    }  
    
    // display a Game Over screen 
    if (Pac.lives == 0)
       while(!key[KEY_ESC] && !key[KEY_SPACE]) //while Esc or Space key isn't pressed
       {                  
          textout(screen, font, "GAME OVER!", SCREEN_W/2-50, SCREEN_H/2, 0);
          textout(screen, font, "Press ESC to quit or SPACE for another game", SCREEN_W/2-190, SCREEN_H/2+20, 0);
       }   
    
    if (key[KEY_SPACE])
    {
       // start again                
       initgame();
       gameloop();
    } 
    else
        shutdown();  
}

void changedir(ball_t *a, ball_t *b)
{          
     // the balls change directions and exchange their velocities
     // since they have equal mass :) 
  
     // check whether their are going in the same direction or not
     // in that case, don't change direction!
     if (a->xd != b->xd)
     {
        a->xd = -1 * a->xd;
        b->xd = -1 * b->xd;
     }

     if (a->yd != b->yd)
     {         
        a->yd = -1 * a->yd;
        b->yd = -1 * b->yd;
     }
     
     temp = a->xs;
     a->xs = b->xs;
     b->xs = temp;
     
     temp = a->ys;
     a->ys = b->ys;
     b->ys = temp;       

 }

/*
void increment_seconds()
{
    elapsed_seconds++;
}
END_OF_FUNCTION(increment_seconds(int val));
*/
