#ifndef TABLERO_H
#define TABLERO_H

#include "constantes.h"
#include <allegro.h>
#include "sprites.h"
#include "datos.h"
#include "ficha.h"
#include "mensajes.h"
#include "niveles.h"
#include "sonido.h"

class Ficha;

class Tablero {                                                                 // TABLERO
      public:
             Tablero ();
             ~Tablero ();
             void dibuja(int Level);
             const int contenido (int v, int h);
             int grabaficha (int v, int h, Ficha *ficha);
             int buscalineas (int &lineas3, int &lineas4, int &lineas5);
             int MiraAltura ();
             void BuscaAyuda (Ficha *ficha);
             void MuestraAyudas ();
             void QuitaAyudas ();
             void ActualizaBombas ();
      private:
              void GrabaBomba (int v, int h);
              void Explosion (int v,int h);
              void CaeBomba (int v,int h);
              void MuestraBombas ();
              void AnadeAyuda (int v, int h, char bit);
              void AnadeLinea (int Ver,int Hor, int Direccion, int Casillas);              
              void dibujabola (int v, int h, int color);
              void gravedad (int v, int h);
              bool iguales (int v1, int h1, int v2, int h2);
              bool iguales (int v1, int h1, int v2, int h2, int color);
              void LimpiaLineas ();
              int casilla [MAXIMAALTURA+1][MAXIMAANCHURA], menos1[MAXIMAANCHURA], menos2[MAXIMAANCHURA];
              int Horizontal, Vertical, lineast, altura, Ayudas, Fotograma, Lev, Bombas;
              Niveles *DatosNivel;
              Sprites *Set;
              Mensajes *sms;
              Sonido *Sound;
              DATAFILE *fichero;
              struct {
                     int v;
                     int h;
                     int casillas;
                     int sentido;} lineas[10];
              struct {int v;
                      int h;
                      char bit;} Ayuda [64];
              struct {int v;
                      int h;
                      int Foto;} Bomba [10];
};

#endif
