#include "tablero.h"

Tablero::Tablero (){
      int n, m;
      for (n=0;n<=MAXIMAALTURA+1;n++)
          for (m=0;m<MAXIMAANCHURA;m++)
              if (n!=MAXIMAALTURA)casilla [n][m]=0;       // La ultima fila (fuera de la pantalla) vale 9
                 else casilla [n][m]=9;
      altura=0; Ayudas = 0; Bombas = 0;
      fichero = load_datafile ("columns.dat");
      for (m=0;m<MAXIMAANCHURA;m++) {
          menos1[m]=0;menos2[m]=0;}      
      Set = new Sprites;
      sms = new Mensajes;
      DatosNivel = new Niveles;
      Sound = new Sonido;
}

Tablero::~Tablero (){
       delete Set;
       delete sms;
       delete DatosNivel;
       delete Sound;
       unload_datafile (fichero);     
}

void Tablero::dibuja (int Level){
     Lev = Level;
     int xi,xf,yi,yf,fxi,fxf,fyi,fyf,n,m;
     char texto[10], niv[3];
     xi = ANCHOFICHA;
     yi = ALTOPANTALLA - MAXIMAALTURA*ALTOFICHA - 2;
     xf = ANCHOFICHA*(MAXIMAANCHURA+1)+2;
     yf = ALTOPANTALLA-1;
     fxi = xf + ANCHOFICHA - 3;
     fxf = fxi + ANCHOFICHA + 2;
     fyi = yi - 1;
     fyf = yi + 3 * ALTOFICHA + 1;
     clear_bitmap (screen);
     draw_sprite (screen,(BITMAP *)fichero[FondoJuego].dat,0,0);
     rectfill(screen,xi,yi,xf,yf,0);
     rectfill(screen,fxi,fyi,fxf,fyf,0);  
     rect(screen,xi,yi,xf,yf,makecol32(255,255,255));
     rect(screen,fxi,fyi,fxf,fyf,makecol32(255,255,255));
     for (n=0;n<6;n++)                                                          // Pone las fichas pequeas para las estadisticas
         Set->Dibuja (380,110+(16*n),n,15,15);
     for (n=MAXIMAALTURA-1;n>=0;n--)
         for (m=0;m<MAXIMAANCHURA;m++)
             if (contenido (n,m)!=0) dibujabola (n,m,contenido (n,m));
     strcpy (texto, "---- ");
     strcat (texto, sms->Leer(22));
     sprintf (niv, "%i", Lev);
     strcat (texto, niv);
     strcat (texto, " ----");
     text_mode (-1);
     textout_centre (screen, (FONT *)fichero[Peque].dat, texto, 495, 220, -1);

     strcpy (texto, sms->Leer(23));
     sprintf (niv, "%i", DatosNivel->RetLineas(Lev));
     strcat (texto, niv);
     strcat (texto, sms->Leer(24));
     textout_centre (screen, (FONT *)fichero[Peque].dat, texto, 495, 260, -1);
     
     strcpy (texto, sms->Leer(27));
     strcat (texto, sms->Leer(28+DatosNivel->RetAyuda(Lev)));
     text_mode (-1);
     textout_centre (screen, (FONT *)fichero[Peque].dat, texto, 495, 300, -1);

     textout_centre (screen, (FONT *)fichero[Peque].dat, sms->Leer(39), 495, 360, -1);
     if ((DatosNivel->RetHorizontal(Lev)) && (DatosNivel->RetVertical(Lev)) && (DatosNivel->RetDiagonal(Lev)))
        textout_centre (screen, (FONT *)fichero[Peque].dat, sms->Leer(40), 495, 380, -1);
        else {
              int LT;
              LT = DatosNivel->RetHorizontal(Lev) + DatosNivel->RetVertical(Lev) + DatosNivel->RetDiagonal(Lev);
              if (LT==1) {
                         if (DatosNivel->RetHorizontal(Lev))
                            textout_centre (screen, (FONT *)fichero[Peque].dat, sms->Leer(41), 495, 380, -1);
                         if (DatosNivel->RetVertical(Lev))
                            textout_centre (screen, (FONT *)fichero[Peque].dat, sms->Leer(42), 495, 380, -1);
                         if (DatosNivel->RetDiagonal(Lev))
                            textout_centre (screen, (FONT *)fichero[Peque].dat, sms->Leer(43), 495, 380, -1);}
                 else {
                       strcpy (texto,"");                         
                       if (DatosNivel->RetHorizontal(Lev)) {
                            strcpy (texto, sms->Leer(41));
                            strcat (texto, sms->Leer(44));
                            LT-=1;}
                       if (DatosNivel->RetVertical(Lev)) {
                            strcat (texto, sms->Leer(42));
                            if (LT>1) strcat (texto, sms->Leer(44));}
                       if (DatosNivel->RetDiagonal(Lev))
                            strcat (texto, sms->Leer(43));                       
                            
                       textout_centre (screen, (FONT *)fichero[Peque].dat, texto, 495, 380, -1);}                      
              }
     
}

const int Tablero::contenido (int v, int h) {
    if ((v<0) || (v>=MAXIMAALTURA) ||
        (h<0) || (h>=MAXIMAANCHURA))
              return -2;
    if (casilla[v][h] == 11) return -11;
    if (casilla[v][h] == 9) return -9;
    return casilla[v][h];}
    
bool Tablero::iguales (int v1, int h1, int v2, int h2) {
     if (contenido (v1,h1)<1 || contenido (v2,h2)<1) return false;
     if (contenido (v1,h1) == contenido (v2,h2) || contenido (v1,h1) == 10 || contenido (v2,h2) == 10) return true;
        else
            return false;
}

bool Tablero::iguales (int v1, int h1, int v2, int h2, int color) {
     if (contenido (v1,h1)<1) return false;
     if (contenido (v2,h2)<1) return false;
     if (color==11) return false;
     if ((color == contenido (v2,h2) || color == contenido (v1,h1) || color == 10) && iguales (v1,h1,v2,h2))
       return true;
        else
            return false;
}

void Tablero::LimpiaLineas () {     
     int n,m, AltTemp=0;
     for (n=MAXIMAALTURA-1;n>=0;n--)
        for (m=0;m<MAXIMAANCHURA;m++)
            while (contenido (n,m) == -1)
                  gravedad (n,m);

     for (m=0;m<MAXIMAANCHURA;m++)
         for (n=0;n<MAXIMAALTURA;n++)
             if ((contenido (n,m)>0) && (MAXIMAALTURA-n > AltTemp))
                AltTemp = MAXIMAALTURA-n;
     altura = AltTemp;
     
}
  
int Tablero::grabaficha (int v, int h, Ficha *ficha){
    int a,b,c, altTemp,m;
    altTemp = ficha->coordv();
    ficha->miracolor (a,b,c);
    
    if (a==9) GrabaBomba (v,h);
    if (b==9) GrabaBomba (v+1,h);
    if (c==9) GrabaBomba (v+2,h);
    
    if (altTemp>=-2){
       casilla [v+2][h]=c;
       if (altTemp == -2) {menos1[h]=b;menos2[h]=a;}}                     // Casilla de mas abajo
    if (altTemp>=-1){
       casilla [v+1][h]=b;
       if (altTemp == -1) menos1[h]=a;}                                   // Casilla del medio
    if (altTemp>=0) casilla [v][h]=a;                      // Casilla de mas arriba
    if (altTemp<0) return altTemp;
    altTemp = MAXIMAALTURA - v;
    if (altTemp > altura) altura = altTemp;
    return altura;
}

void Tablero::GrabaBomba (int v, int h) {
     Bomba[Bombas].v=v;
     Bomba[Bombas].h=h;
     Bomba[Bombas++].Foto=0;
     return;
}

void Tablero::ActualizaBombas () {
     if (!Bombas) return;
     int n,x,y;
     for (n=0;n<Bombas;n++) {
         Bomba[n].Foto+=1;
         if (Bomba[n].Foto<7) {
            x = 1 + ANCHOFICHA*(Bomba[n].h+1);
            y = (ALTOPANTALLA-1)-MAXIMAALTURA*ALTOFICHA;
            y += ALTOFICHA * Bomba[n].v;
            Set->DibujaBomba (x,y,Bomba[n].Foto);}
          else
            Explosion (Bomba[n].v, Bomba[n].h);}
     return;
}

void Tablero::MuestraBombas () {
     if (!Bombas) return;
     int n,x,y;
     for (n=0;n<Bombas;n++) {
         x = 1 + ANCHOFICHA*(Bomba[n].h+1);
         y = (ALTOPANTALLA-1)-MAXIMAALTURA*ALTOFICHA;
         y += ALTOFICHA * Bomba[n].v;
         Set->DibujaBomba (x,y,Bomba[n].Foto);}
     return;
}

void Tablero::Explosion (int v, int h) {
     int n,m;
     Bombas-=1;
     for (n=v-1;n<v+2;n++)
         for (m=h-1;m<h+2;m++) {
             if (contenido (n,m)!=-2 && contenido (n,m)!=-11) {
                casilla [n][m] = -1;
                dibujabola (n,m,8);
                Sound->SExpl ();}}
     rest (200);
     LimpiaLineas ();
     return;
}

void Tablero::AnadeLinea (int Ver, int Hor, int Direccion, int Casillas) {   
    lineas[lineast].v = Ver;
    lineas[lineast].h = Hor;
    lineas[lineast].casillas = Casillas;
    lineas[lineast++].sentido = Direccion;
}
     

int Tablero::buscalineas (int &lineas3, int &lineas4, int &lineas5){
    int n, m;
    lineas5 = 0, lineas4 = 0, lineas3 = 0; lineast=0;
    
    for (Vertical=MAXIMAALTURA-1; Vertical>=0; Vertical--)
        for (Horizontal=0; Horizontal<MAXIMAANCHURA; Horizontal++){

          if (contenido(Vertical,Horizontal) > 0 && contenido (Vertical,Horizontal)<12) {
                                             
if (DatosNivel->RetHorizontal(Lev))
          if ((!iguales (Vertical,Horizontal,Vertical,Horizontal-1) || contenido(Vertical,Horizontal)==10) &&
              iguales (Vertical, Horizontal, Vertical,Horizontal+1) &&
              iguales (Vertical, Horizontal+1, Vertical, Horizontal+2) &&
              iguales (Vertical, Horizontal, Vertical, Horizontal+2)) {
              if (iguales (Vertical,Horizontal+2, Vertical,Horizontal+3) &&
                  iguales (Vertical,Horizontal+1, Vertical,Horizontal+3) &&
                  iguales (Vertical,Horizontal,Vertical,Horizontal+3))
                 if (iguales (Vertical,Horizontal+3, Vertical, Horizontal+4) &&
                     iguales (Vertical,Horizontal+2, Vertical,Horizontal+4) &&
                     iguales (Vertical,Horizontal+1, Vertical,Horizontal+4) &&
                     iguales (Vertical,Horizontal,Vertical,Horizontal+4)) {
                              AnadeLinea (Vertical,Horizontal,0,5);
                              lineas5++;}
                     else {                              
                              AnadeLinea (Vertical,Horizontal,0,4);
                              lineas4++;}
                 else {
                              AnadeLinea (Vertical,Horizontal,0,3);
                              lineas3++;}}

if (DatosNivel->RetVertical(Lev))
          if ((!iguales (Vertical+1,Horizontal,Vertical,Horizontal) || contenido(Vertical,Horizontal)==10) &&
              iguales (Vertical, Horizontal, Vertical-1,Horizontal) &&
              iguales (Vertical-1, Horizontal, Vertical-2, Horizontal) &&
              iguales (Vertical, Horizontal, Vertical-2, Horizontal)) {
              if (iguales (Vertical-2,Horizontal, Vertical-3,Horizontal) &&
                  iguales (Vertical-1,Horizontal, Vertical-3,Horizontal) &&
                  iguales (Vertical,Horizontal,Vertical-3,Horizontal))
                 if (iguales (Vertical-3,Horizontal, Vertical-4, Horizontal) &&
                     iguales (Vertical-2,Horizontal, Vertical-4,Horizontal) &&
                     iguales (Vertical-1,Horizontal, Vertical-4,Horizontal) &&
                     iguales (Vertical,Horizontal,Vertical-4,Horizontal)) {
                              AnadeLinea (Vertical,Horizontal,1,5);
                              lineas5++;}
                     else {                              
                              AnadeLinea (Vertical,Horizontal,1,4);
                              lineas4++;}
                 else {
                              AnadeLinea (Vertical,Horizontal,1,3);
                              lineas3++;}}

if (!DatosNivel->RetDiagonal(Lev)) continue;

          if ((!iguales (Vertical,Horizontal,Vertical+1,Horizontal-1) || contenido(Vertical,Horizontal)==10) &&
              iguales (Vertical, Horizontal, Vertical-1,Horizontal+1) &&
              iguales (Vertical-1, Horizontal+1, Vertical-2, Horizontal+2) &&
              iguales (Vertical, Horizontal, Vertical-2, Horizontal+2)) {
              if (iguales (Vertical-2,Horizontal+2, Vertical-3,Horizontal+3) &&
                  iguales (Vertical-1,Horizontal+1, Vertical-3,Horizontal+3) &&
                  iguales (Vertical,Horizontal,Vertical-3,Horizontal+3))
                 if (iguales (Vertical-3,Horizontal+3, Vertical-4, Horizontal+4) &&
                     iguales (Vertical-2,Horizontal+2, Vertical-4,Horizontal+4) &&
                     iguales (Vertical-1,Horizontal+1, Vertical-4,Horizontal+4) &&
                     iguales (Vertical,Horizontal,Vertical-4,Horizontal+4)) {
                              AnadeLinea (Vertical,Horizontal,2,5);
                              lineas5++;}
                     else {                              
                              AnadeLinea (Vertical,Horizontal,2,4);
                              lineas4++;}
                 else {
                              AnadeLinea (Vertical,Horizontal,2,3);
                              lineas3++;}}

          if ((!iguales (Vertical,Horizontal,Vertical-1,Horizontal-1) || contenido(Vertical,Horizontal)==10) &&
              iguales (Vertical, Horizontal, Vertical+1,Horizontal+1) &&
              iguales (Vertical+1, Horizontal+1, Vertical+2, Horizontal+2) &&
              iguales (Vertical, Horizontal, Vertical+2, Horizontal+2)) {
              if (iguales (Vertical+2,Horizontal+2, Vertical+3,Horizontal+3) &&
                  iguales (Vertical+1,Horizontal+1, Vertical+3,Horizontal+3) &&
                  iguales (Vertical,Horizontal,Vertical+3,Horizontal+3))
                 if (iguales (Vertical+3,Horizontal+3, Vertical+4, Horizontal+4) &&
                     iguales (Vertical+2,Horizontal+2, Vertical+4,Horizontal+4) &&
                     iguales (Vertical+1,Horizontal+1, Vertical+4,Horizontal+4) &&
                     iguales (Vertical,Horizontal,Vertical+4,Horizontal+4)) {
                              AnadeLinea (Vertical,Horizontal,3,5);
                              lineas5++;}
                     else {                              
                              AnadeLinea (Vertical,Horizontal,3,4);
                              lineas4++;}
                 else {
                              AnadeLinea (Vertical,Horizontal,3,3);
                              lineas3++;}}}}
                                                  
    if (!lineast) return 0;                                                      // Si no se han hecho lineas, vuelvete ya.
       
    for (n=0; n<lineast; n++){
        switch (lineas[n].sentido) {
               case 0: {
                    for (m=0;m<lineas[n].casillas;m++) {
                        casilla [lineas[n].v][(lineas[n].h)+m] = -1;
                        dibujabola (lineas[n].v,(lineas[n].h)+m,7);}
                    break;}
               case 1: {
                    for (m=0;m<lineas[n].casillas;m++) {
                        casilla [(lineas[n].v)-m][lineas[n].h] = -1;
                        dibujabola ((lineas[n].v)-m,lineas[n].h,7);}
                    break;}
               case 2: {
                    for (m=0;m<lineas[n].casillas;m++){
                        casilla [(lineas[n].v)-m][(lineas[n].h)+m] = -1;
                        dibujabola ((lineas[n].v)-m,(lineas[n].h)+m,7);}
                    break;}
               case 3: {
                    for (m=0;m<lineas[n].casillas;m++){
                        casilla [(lineas[n].v)+m][(lineas[n].h)+m] = -1;
                        dibujabola ((lineas[n].v)+m,(lineas[n].h)+m,7);}
                    break;}
        }
    }

    rest (200);
    LimpiaLineas ();
    return lineast;
}

void Tablero::BuscaAyuda (Ficha *ficha) {
     int color[3], Vertical, Horizontal, colores;
     ficha->miracolor (color[0],color[1],color[2]);
     Ayudas = 0; Fotograma = 0;
     if (!altura) return;     
     for (Vertical = 0; Vertical < MAXIMAALTURA; Vertical++)
         for (Horizontal = 0; Horizontal < MAXIMAANCHURA; Horizontal++) {
             
             if (contenido (Vertical,Horizontal)!=0) continue; // Solo comprobaremos casillas vacias

             if (((color[1] == 10) || (color [2] == 10) || (color[1] == color[2]))
             && (iguales (Vertical+1,Horizontal,Vertical+1,Horizontal, color[2]))
             && (iguales (Vertical+1,Horizontal,Vertical+1,Horizontal, color[1])))
                AnadeAyuda (Vertical,Horizontal,0x04);
                           
             for (colores = 0; colores < 3; colores++) { // Para cada una de las 3 figuras de la ficha
            
                 if ((colores == 0) &&                                    // Estos if sirven para que solo busque
                     ((contenido (Vertical+2,Horizontal)!=0) ||           // ayuda con la ficha tal como viene
                      (contenido (Vertical+3,Horizontal)==0))) continue;  // con los colores en ese orden

                 if ((colores == 1) && 
                     ((contenido (Vertical+1,Horizontal)!=0) ||
                      (contenido (Vertical+2,Horizontal)==0))) continue;

                 if ((colores == 2) && 
                     ((contenido (Vertical+1,Horizontal)==0))) continue;
                     
                 if (iguales (Vertical, Horizontal+1, Vertical, Horizontal+2, color[colores]))// Las dos siguientes son iguales y
                             AnadeAyuda (Vertical,Horizontal,0x01);
                 if (iguales (Vertical, Horizontal-1, Vertical, Horizontal-2, color[colores])) // Las dos siguientes son iguales y
                             AnadeAyuda (Vertical,Horizontal,0x02);
                 if (iguales (Vertical, Horizontal+1, Vertical, Horizontal-1, color[colores]))
                             AnadeAyuda (Vertical,Horizontal,0x03);

                 if (iguales (Vertical+1, Horizontal, Vertical+2, Horizontal, color[colores]))
                             AnadeAyuda (Vertical,Horizontal,0x04);                               
                                
                 if (iguales (Vertical+1, Horizontal-1, Vertical+2, Horizontal-2, color[colores]))
                             AnadeAyuda (Vertical,Horizontal,0x10);
                 if (iguales (Vertical-1, Horizontal+1, Vertical-2, Horizontal+2, color[colores]))
                             AnadeAyuda (Vertical,Horizontal,0x20);
                 if (iguales (Vertical-1, Horizontal+1, Vertical+1, Horizontal-1, color[colores]))
                             AnadeAyuda (Vertical,Horizontal,0x30);
                                
                 if (iguales (Vertical+1, Horizontal+1, Vertical+2, Horizontal+2, color[colores]))
                             AnadeAyuda (Vertical,Horizontal, 0x40);
                 if (iguales (Vertical-1, Horizontal-1, Vertical-2, Horizontal-2, color[colores]))
                             AnadeAyuda (Vertical,Horizontal, 0x80);
                 if (iguales (Vertical+1, Horizontal+1, Vertical-1, Horizontal-1, color[colores]))
                             AnadeAyuda (Vertical,Horizontal, 0xc0);                                            
                 }  // For Colores
             } // For CASILLAS
}

void Tablero::AnadeAyuda (int v, int h, char bit) {
     int n;
     for (n=0; n<Ayudas; n++)
         if ((Ayuda[n].v == v) &&
             (Ayuda[n].h == h)) {
                         Ayuda[n].bit = Ayuda[n].bit | bit;
                         return;}
     Ayuda[Ayudas].v = v;
     Ayuda[Ayudas].h = h;
     Ayuda[Ayudas++].bit = bit;
     return;
}

void Tablero::MuestraAyudas () {
     int n, x, y;
     for (n=0;n<Ayudas;n++) {
         x = 1 + ANCHOFICHA*(Ayuda[n].h+1);
         y = (ALTOPANTALLA-1)-MAXIMAALTURA*ALTOFICHA;
         y += ALTOFICHA * Ayuda[n].v;
         if (Ayuda[n].bit & 0x01)
            masked_blit ((BITMAP*)fichero[Flechas].dat, screen, ANCHOFICHA * Fotograma, 0, x,y,ANCHOFICHA,ALTOFICHA);
         if (Ayuda[n].bit & 0x02)
            masked_blit ((BITMAP*)fichero[Flechas].dat, screen, ANCHOFICHA * Fotograma, ALTOFICHA, x,y,ANCHOFICHA,ALTOFICHA);
         if (Ayuda[n].bit & 0x04)
            masked_blit ((BITMAP*)fichero[Flechas].dat, screen, ANCHOFICHA * Fotograma, 2*ALTOFICHA, x,y,ANCHOFICHA,ALTOFICHA);
         if (Ayuda[n].bit & 0x08)
            masked_blit ((BITMAP*)fichero[Flechas].dat, screen, ANCHOFICHA * Fotograma, 3*ALTOFICHA, x,y,ANCHOFICHA,ALTOFICHA);
         if (Ayuda[n].bit & 0x10)
            masked_blit ((BITMAP*)fichero[Flechas].dat, screen, ANCHOFICHA * Fotograma, 4*ALTOFICHA, x,y,ANCHOFICHA,ALTOFICHA);
         if (Ayuda[n].bit & 0x20)
            masked_blit ((BITMAP*)fichero[Flechas].dat, screen, ANCHOFICHA * Fotograma, 5*ALTOFICHA, x,y,ANCHOFICHA,ALTOFICHA);
         if (Ayuda[n].bit & 0x40)
            masked_blit ((BITMAP*)fichero[Flechas].dat, screen, ANCHOFICHA * Fotograma, 6*ALTOFICHA, x,y,ANCHOFICHA,ALTOFICHA);
         if (Ayuda[n].bit & 0x80)
            masked_blit ((BITMAP*)fichero[Flechas].dat, screen, ANCHOFICHA * Fotograma, 7*ALTOFICHA, x,y,ANCHOFICHA,ALTOFICHA);            
            }
     if (++Fotograma ==5) Fotograma = 0;
}
     

void Tablero::QuitaAyudas () {
     int n;
     for (n=0;n<Ayudas;n++)
         dibujabola (Ayuda[n].v,Ayuda[n].h,contenido (Ayuda[n].v,Ayuda[n].h));
     return;
}

void Tablero::dibujabola (int v, int h, int color){
     int x,y;     
     x = 1 + ANCHOFICHA*(h+1);
     y = (ALTOPANTALLA-1)-MAXIMAALTURA*ALTOFICHA;
     y += ALTOFICHA * v;
     if (color==-9) MuestraBombas();
     if (color==-11) color=11;
     if ((color<1) || (color>12)) color = 12;
     Set->Dibuja (x,y,color);
}

void Tablero::gravedad(int v, int h){                                              // Deja caer una fila la columna que se le diga, desde la fila v
     int n=v;
     do {
         if (contenido(n,h) == -9) CaeBomba (n,h);
         casilla [n][h] = contenido (n-1,h);
         dibujabola (n,h,contenido (n,h));
         } while (contenido (n--,h)!=0 | n==0);
     casilla [0][h] = menos1 [h];
     dibujabola (0,h,contenido (0,h));
     menos1[h]=menos2[h];
     menos2[h]=0;
}

void Tablero::CaeBomba (int v, int h) {
     int n;
     for (n=0;n<Bombas;n++)
         if (Bomba[n].v==v && Bomba[n].h==h)
            Bomba[n].v+=1;
}

int Tablero::MiraAltura () {
    int m;
    for (m=0;m<MAXIMAANCHURA;m++)
    if (menos1[m]) altura=-1;
    return altura;
}
