#include "sonido.h" // class's header file

Sonido::Sonido()
{
    Fichero = load_datafile ("columns.dat");
    Config = new Configuracion;
    Sonar = Config->Sonido();
}

Sonido::~Sonido()
{                
    delete Config;
    unload_datafile (Fichero);
}

void Sonido::SGrabaFicha () {
    Sonar = Config->Sonido();
     if (Sonar)
        play_sample ((SAMPLE *) Fichero[SDGrabaFicha].dat,150,128,1000,0);
     }

void Sonido::SGameOver () {
    Sonar = Config->Sonido();
     if (Sonar)
        play_sample ((SAMPLE *) Fichero[SDGameOver].dat,200,128,1000,0);
     }

void Sonido::SHaceLinea () {
    Sonar = Config->Sonido();
     if (Sonar)
        play_sample ((SAMPLE *) Fichero[SDHaceLinea].dat,200,128,1000,0);
     }

void Sonido::SFinNivel () {
    Sonar = Config->Sonido();
     if (Sonar)
        play_sample ((SAMPLE *) Fichero[SDFinNivel].dat,200,128,1000,0);
     }

void Sonido::SBonus () {
    Sonar = Config->Sonido();
     if (Sonar)
        play_sample ((SAMPLE *) Fichero[SDBonus].dat,200,128,1000,0);
     }

void Sonido::SNivel () {
    Sonar = Config->Sonido();
     if (Sonar)
        play_sample ((SAMPLE *) Fichero[SDNivel].dat,200,128,1000,0);
     }
     
void Sonido::SExpl () {
    Sonar = Config->Sonido();
     if (Sonar)
        play_sample ((SAMPLE *) Fichero[SDExpl].dat,200,128,1000,0); 
}

void Sonido::MMenu () {
    Sonar = Config->Sonido();
     if (Sonar) {
        MIDI *cancion;
        cancion = (MIDI *) Fichero[Allegro].dat;
        if (midi_pos<0) play_midi(cancion, 1);}
}

void Sonido::MNivel (int nivel) {
     Sonar = Config->Sonido();
     if (!Sonar) return;
     while (nivel>4) nivel-=5;
     play_midi ((MIDI *) Fichero[Music0+nivel].dat,1);
}

void Sonido::MStop () {
     play_midi (NULL,0); }
