#include <allegro.h>
#include <winalleg.h>
#include "erkMap.h"
#include "erkBmpGen.h"

erkTileType::erkTileType() :
	m_bSolid(false)
{
}

erkTileType::~erkTileType()
{
}

void erkTileType::Build(BITMAP* pBase)
{
	m_pvBmps.resize(17, NULL);

	m_pvBmps[0] = erkGenLightOn(pBase);
	m_pvBmps[1] = erkGenLightOff(pBase, false, false, false, false);
	m_pvBmps[2] = erkGenLightOff(pBase, true, false, false, false);
	m_pvBmps[3] = erkGenLightOff(pBase, false, true, false, false);
	m_pvBmps[4] = erkGenLightOff(pBase, true, true, false, false);
	m_pvBmps[5] = erkGenLightOff(pBase, false, false, true, false);
	m_pvBmps[6] = erkGenLightOff(pBase, true, false, true, false);
	m_pvBmps[7] = erkGenLightOff(pBase, false, true, true, false);
	m_pvBmps[8] = erkGenLightOff(pBase, true, true, true, false);
	m_pvBmps[9] = erkGenLightOff(pBase, false, false, false, true);
	m_pvBmps[10] = erkGenLightOff(pBase, true, false, false, true);
	m_pvBmps[11] = erkGenLightOff(pBase, false, true, false, true);
	m_pvBmps[12] = erkGenLightOff(pBase, true, true, false, true);
	m_pvBmps[13] = erkGenLightOff(pBase, false, false, true, true);
	m_pvBmps[14] = erkGenLightOff(pBase, true, false, true, true);
	m_pvBmps[15] = erkGenLightOff(pBase, false, true, true, true);
	m_pvBmps[16] = erkGenLightOff(pBase, true, true, true, true);
}

void erkTileType::Update(erkTile_p pTile)
{
}

void erkTileType::EffectUnit(erkUnit_p pUnit, erkTile_p pTile)
{
	if(pTile->IsLit() == pUnit->GetSide())
	{
		pUnit->IncHealth(1);
	}
	else
	{
		pUnit->DecHealth(1);
	}
}

BITMAP* erkTileType::GetLit()
{
	return m_pvBmps[0];
}

BITMAP* erkTileType::GetUnlit(gbInt dwNeighbourType)
{
	dwNeighbourType = dwNeighbourType&0xF;

	return m_pvBmps[dwNeighbourType+1];
}

void erkTileType::SetBmp(gbInt dwIndex, BITMAP* pBmp)
{
	if(dwIndex >= 0  &&  dwIndex < m_pvBmps.size())
	{
		if(m_pvBmps[dwIndex])
			destroy_bitmap(m_pvBmps[dwIndex]);

		m_pvBmps[dwIndex] = erkGenClone(pBmp);
	}
}

void erkTileType::SetSolid(gbBool bSolid)
{
	m_bSolid = bSolid;
}

BITMAP* erkTileType::GetBmp(gbInt dwIndex)
{
	if(dwIndex >= 0  &&  dwIndex < m_pvBmps.size())
	{
		return m_pvBmps[dwIndex];
	}

	return NULL;
}

gbBool erkTileType::IsSolid()
{
	return m_bSolid;
}
