#include <allegro.h>
#include <winalleg.h>
#include "erkMap.h"

BITMAP* g_pBmpThorns = NULL;

erkCmdThorns::erkCmdThorns() :
	m_dwHealth(20000),
	m_pSetTo(NULL)
{
	if(!g_pBmpThorns)
		g_pBmpThorns = load_bitmap("Data\\BuildThorns.bmp", NULL);
}

erkCmdThorns::~erkCmdThorns()
{
}

void erkCmdThorns::Draw(BITMAP* pDest, gbInt dwX, gbInt dwY)
{
	gbInt dwR = (rand()>>7)&0x3F;
	gbInt dwColor = m_bSide?makecol(255, (255+dwR)/2, dwR):makecol(dwR, (255+dwR)/2, 255);

	draw_sprite(pDest, g_pBmpThorns, dwX-g_pBmpThorns->w/2, dwY-g_pBmpThorns->h/2);

	gbInt dwSize = 30-(m_dwHealth*30/20000);
	rectfill(pDest, dwX-15, dwY+12, dwX+14, dwY+14, 0);
	rectfill(pDest, dwX-15, dwY+12, dwX-15+dwSize, dwY+14, dwColor);
}

void erkCmdThorns::Update()
{
	gbInt dwDamage = 0;
	for(gbLinkListIter(erkUnit_p) iPos=m_pTile->UnitsBegin(); iPos!=m_pTile->UnitsEnd(); ++iPos)
	{
		if((*iPos)->GetSide() == m_bSide)
		{
			dwDamage++;
		}
	}

	m_dwHealth -= MAX(1, dwDamage/4);
	if(m_dwHealth <= 0)
	{
		m_pTile->SetType(m_pSetTo);
		m_pTile->SetLit(m_bSide);
		m_pTile->SetCommand(m_bSide, NULL);
	}
}

void erkCmdThorns::SetThornsType(erkTileType_p pType)
{
	m_pSetTo = pType;
}
