#include <allegro.h>
#include <winalleg.h>
#include "erkMap.h"

erkCmdNorth::erkCmdNorth()
{
}

erkCmdNorth::~erkCmdNorth()
{
}

void erkCmdNorth::Draw(BITMAP* pDest, gbInt dwX, gbInt dwY)
{
	gbInt dwR = (rand()>>7)&0x3F;
	gbInt dwColor = m_bSide?makecol(255, (255+dwR)/2, dwR):makecol(dwR, (255+dwR)/2, 255);

	hline(pDest, dwX-6, dwY+12, dwX+6, dwColor);
	vline(pDest, dwX-6, dwY+12, dwY-6, dwColor);
	vline(pDest, dwX+6, dwY+12, dwY-6, dwColor);
	hline(pDest, dwX-9, dwY-6, dwX-6, dwColor);
	hline(pDest, dwX+6, dwY-6, dwX+9, dwColor);
	line(pDest, dwX, dwY-12, dwX-9, dwY-6, dwColor);
	line(pDest, dwX, dwY-12, dwX+9, dwY-6, dwColor);
}

void erkCmdNorth::Update()
{
	for(gbLinkListIter(erkUnit_p) iPos=m_pTile->UnitsBegin(); iPos!=m_pTile->UnitsEnd(); ++iPos)
	{
		if((*iPos)->GetSide() == m_bSide)
		{
			(*iPos)->AddVel(0.0f, -0.01f);
		}
	}
}



erkCmdEast::erkCmdEast()
{
}

erkCmdEast::~erkCmdEast()
{
}

void erkCmdEast::Draw(BITMAP* pDest, gbInt dwX, gbInt dwY)
{
	gbInt dwR = (rand()>>7)&0x3F;
	gbInt dwColor = m_bSide?makecol(255, (255+dwR)/2, dwR):makecol(dwR, (255+dwR)/2, 255);

	vline(pDest, dwX-12, dwY+6, dwY-6, dwColor);
	hline(pDest, dwX-12, dwY+6, dwX+6, dwColor);
	hline(pDest, dwX-12, dwY-6, dwX+6, dwColor);
	vline(pDest, dwX+6, dwY+9, dwY+6, dwColor);
	vline(pDest, dwX+6, dwY-6, dwY-9, dwColor);
	line(pDest, dwX+12, dwY, dwX+6, dwY+9, dwColor);
	line(pDest, dwX+12, dwY, dwX+6, dwY-9, dwColor);
}

void erkCmdEast::Update()
{
	for(gbLinkListIter(erkUnit_p) iPos=m_pTile->UnitsBegin(); iPos!=m_pTile->UnitsEnd(); ++iPos)
	{
		if((*iPos)->GetSide() == m_bSide)
		{
			(*iPos)->AddVel(0.01f, 0.0f);
		}
	}
}



erkCmdSouth::erkCmdSouth()
{
}

erkCmdSouth::~erkCmdSouth()
{
}

void erkCmdSouth::Draw(BITMAP* pDest, gbInt dwX, gbInt dwY)
{
	gbInt dwR = (rand()>>7)&0x3F;
	gbInt dwColor = m_bSide?makecol(255, (255+dwR)/2, dwR):makecol(dwR, (255+dwR)/2, 255);

	hline(pDest, dwX-6, dwY-12, dwX+6, dwColor);
	vline(pDest, dwX-6, dwY-12, dwY+6, dwColor);
	vline(pDest, dwX+6, dwY-12, dwY+6, dwColor);
	hline(pDest, dwX-9, dwY+6, dwX-6, dwColor);
	hline(pDest, dwX+6, dwY+6, dwX+9, dwColor);
	line(pDest, dwX, dwY+12, dwX-9, dwY+6, dwColor);
	line(pDest, dwX, dwY+12, dwX+9, dwY+6, dwColor);
}

void erkCmdSouth::Update()
{
	for(gbLinkListIter(erkUnit_p) iPos=m_pTile->UnitsBegin(); iPos!=m_pTile->UnitsEnd(); ++iPos)
	{
		if((*iPos)->GetSide() == m_bSide)
		{
			(*iPos)->AddVel(0.0f, 0.01f);
		}
	}
}



erkCmdWest::erkCmdWest()
{
}

erkCmdWest::~erkCmdWest()
{
}

void erkCmdWest::Draw(BITMAP* pDest, gbInt dwX, gbInt dwY)
{
	gbInt dwR = (rand()>>7)&0x3F;
	gbInt dwColor = m_bSide?makecol(255, (255+dwR)/2, dwR):makecol(dwR, (255+dwR)/2, 255);

	vline(pDest, dwX+12, dwY-6, dwY+6, dwColor);
	hline(pDest, dwX+12, dwY-6, dwX-6, dwColor);
	hline(pDest, dwX+12, dwY+6, dwX-6, dwColor);
	vline(pDest, dwX-6, dwY-9, dwY-6, dwColor);
	vline(pDest, dwX-6, dwY+6, dwY+9, dwColor);
	line(pDest, dwX-12, dwY, dwX-6, dwY-9, dwColor);
	line(pDest, dwX-12, dwY, dwX-6, dwY+9, dwColor);
}

void erkCmdWest::Update()
{
	for(gbLinkListIter(erkUnit_p) iPos=m_pTile->UnitsBegin(); iPos!=m_pTile->UnitsEnd(); ++iPos)
	{
		if((*iPos)->GetSide() == m_bSide)
		{
			(*iPos)->AddVel(-0.01f, 0.0f);
		}
	}
}
