#include <allegro.h>
#include <winalleg.h>
#include "erkMap.h"

erkCmdClear::erkCmdClear() :
	m_dwHealth(100),
	m_pClearTo(NULL)
{
}

erkCmdClear::~erkCmdClear()
{
}

void erkCmdClear::Draw(BITMAP* pDest, gbInt dwX, gbInt dwY)
{
	gbInt dwR = (rand()>>7)&0x3F;
	gbInt dwColor = m_bSide?makecol(255, (255+dwR)/2, dwR):makecol(dwR, (255+dwR)/2, 255);

	line(pDest, dwX-12, dwY-12, dwX+12, dwY+12, dwColor);
	line(pDest, dwX+12, dwY-12, dwX-12, dwY+12, dwColor);
}

void erkCmdClear::Collision(gbBool bSide)
{
	if(bSide != m_bSide)
		return;

	m_dwHealth--;
	if(m_dwHealth <= 0)
	{
		m_pTile->SetType(m_pClearTo);
		m_pTile->SetLit(m_bSide);
		m_pTile->SetHealth(0);
		m_pTile->SetCommand(m_bSide, NULL);
	}
}

void erkCmdClear::SetClearType(erkTileType_p pType)
{
	m_pClearTo = pType;
}
