#include <allegro.h>
#include <winalleg.h>
#include "erkBmpGen.h"

BITMAP* erkGenNoise(gbInt dwColor1, gbInt dwColor2, gbInt dwWidth, gbInt dwHeight)
{
	BITMAP* pOut = create_bitmap(dwWidth, dwHeight);
	if(!pOut)
		return NULL;

	gbInt dwR1 = getr(dwColor1);
	gbInt dwG1 = getg(dwColor1);
	gbInt dwB1 = getb(dwColor1);
	gbInt dwR2 = getr(dwColor2)-dwR1;
	gbInt dwG2 = getg(dwColor2)-dwG1;
	gbInt dwB2 = getb(dwColor2)-dwB1;

	for(int ly=0; ly<dwHeight; ly++)
	{
		for(int lx=0; lx<dwWidth; lx++)
		{
			putpixel(pOut, lx, ly, makecol(dwR1+rand()*dwR2/RAND_MAX, dwG1+rand()*dwG2/RAND_MAX, dwB1+rand()*dwB2/RAND_MAX));
		}
	}

	return pOut;
}

BITMAP* erkGenSmooth(BITMAP* pIn)
{
	BITMAP* pOut = create_bitmap(pIn->w, pIn->h);
	if(!pOut)
		return NULL;

	gbInt dwColor, dwR, dwG, dwB, dwCount;
	for(int ly=0; ly<pIn->h; ly++)
	{
		for(int lx=0; lx<pIn->w; lx++)
		{
			dwColor = getpixel(pIn, lx, ly);
			dwR = getr(dwColor);
			dwG = getg(dwColor);
			dwB = getb(dwColor);
			dwCount = 1;
			if(lx > 0)
			{
				dwColor = getpixel(pIn, lx-1, ly);
				dwR += getr(dwColor);
				dwG += getg(dwColor);
				dwB += getb(dwColor);
				dwCount++;
			}
			if(ly > 0)
			{
				dwColor = getpixel(pIn, lx, ly-1);
				dwR += getr(dwColor);
				dwG += getg(dwColor);
				dwB += getb(dwColor);
				dwCount++;
			}
			if(lx < pIn->w-1)
			{
				dwColor = getpixel(pIn, lx+1, ly);
				dwR += getr(dwColor);
				dwG += getg(dwColor);
				dwB += getb(dwColor);
				dwCount++;
			}
			if(ly < pIn->h-1)
			{
				dwColor = getpixel(pIn, lx, ly+1);
				dwR += getr(dwColor);
				dwG += getg(dwColor);
				dwB += getb(dwColor);
				dwCount++;
			}
			dwR /= dwCount;
			dwG /= dwCount;
			dwB /= dwCount;

			putpixel(pOut, lx, ly, makecol(dwR, dwG, dwB));
		}
	}

	return pOut;
}

BITMAP* erkGenClone(BITMAP* pIn)
{
	BITMAP* pOut = create_bitmap(pIn->w, pIn->h);
	if(!pOut)
		return NULL;

	blit(pIn, pOut, 0, 0, 0, 0, pIn->w, pIn->h);

	return pOut;
}

BITMAP* erkGenLightOn(BITMAP* pIn)
{
	BITMAP* pOut = create_bitmap(pIn->w, pIn->h);
	if(!pOut)
		return NULL;

	BITMAP* pLight = create_bitmap(pIn->w, pIn->h);
	if(!pLight)
	{
		destroy_bitmap(pOut);
		return NULL;
	}
	clear(pLight);

	gbInt dwRad1 = (gbInt)(pIn->w*1.414213f)/2;
	gbInt dwRad2 = dwRad1*15/16;
	gbInt dwRad3 = dwRad1*14/16;
	gbInt dwRad4 = dwRad1*13/16;
	gbInt dwRad5 = dwRad1*12/16;
	gbInt dwRad6 = dwRad1*11/16;
	gbInt dwRad7 = dwRad1*10/16;
	gbInt dwRad8 = dwRad1*9/16;

	circlefill(pLight, pIn->w/2, pIn->w/2, dwRad1, 32);
	circlefill(pLight, pIn->w/2, pIn->w/2, dwRad2, 64);
	circlefill(pLight, pIn->w/2, pIn->w/2, dwRad3, 96);
	circlefill(pLight, pIn->w/2, pIn->w/2, dwRad4, 128);
	circlefill(pLight, pIn->w/2, pIn->w/2, dwRad5, 160);
	circlefill(pLight, pIn->w/2, pIn->w/2, dwRad6, 192);
	circlefill(pLight, pIn->w/2, pIn->w/2, dwRad7, 224);
	circlefill(pLight, pIn->w/2, pIn->w/2, dwRad8, 255);

	gbInt dwColor, dwR, dwG, dwB, dwLight;
	for(int ly=0; ly<pIn->h; ly++)
	{
		for(int lx=0; lx<pIn->w; lx++)
		{
			dwLight = getpixel(pLight, lx, ly);
			dwLight = MID(0, dwLight, 255);
			dwLight = dwLight/2+128;
			dwColor = getpixel(pIn, lx, ly);
			dwR = getr(dwColor);
			dwG = getg(dwColor);
			dwB = getb(dwColor);

			putpixel(pOut, lx, ly, makecol(dwR*dwLight/255, dwG*dwLight/255, dwB*dwLight/255));
		}
	}

	destroy_bitmap(pLight);

	return pOut;
}

BITMAP* erkGenLightOff(BITMAP* pIn, gbBool bNorth, gbBool bEast, gbBool bSouth, gbBool bWest)
{
	BITMAP* pOut = create_bitmap(pIn->w, pIn->h);
	if(!pOut)
		return NULL;

	BITMAP* pLight = create_bitmap(pIn->w, pIn->h);
	if(!pLight)
	{
		destroy_bitmap(pOut);
		return NULL;
	}
	clear(pLight);

	gbInt dwRad1 = (gbInt)(pIn->w*1.414213f)/2;
	gbInt dwRad2 = dwRad1*15/16;
	gbInt dwRad3 = dwRad1*14/16;
	gbInt dwRad4 = dwRad1*13/16;
	gbInt dwRad5 = dwRad1*12/16;
	gbInt dwRad6 = dwRad1*11/16;
	gbInt dwRad7 = dwRad1*10/16;
	gbInt dwRad8 = dwRad1*9/16;

	if(bNorth)
	{
		circlefill(pLight, pIn->w/2, -pIn->w/2, dwRad1, 32);
		circlefill(pLight, pIn->w/2, -pIn->w/2, dwRad2, 64);
		circlefill(pLight, pIn->w/2, -pIn->w/2, dwRad3, 96);
		circlefill(pLight, pIn->w/2, -pIn->w/2, dwRad4, 128);
		circlefill(pLight, pIn->w/2, -pIn->w/2, dwRad5, 160);
		circlefill(pLight, pIn->w/2, -pIn->w/2, dwRad6, 192);
		circlefill(pLight, pIn->w/2, -pIn->w/2, dwRad7, 224);
		circlefill(pLight, pIn->w/2, -pIn->w/2, dwRad8, 255);
	}
	if(bWest)
	{
		circlefill(pLight, -pIn->w/2, pIn->w/2, dwRad1, 32);
		circlefill(pLight, -pIn->w/2, pIn->w/2, dwRad2, 64);
		circlefill(pLight, -pIn->w/2, pIn->w/2, dwRad3, 96);
		circlefill(pLight, -pIn->w/2, pIn->w/2, dwRad4, 128);
		circlefill(pLight, -pIn->w/2, pIn->w/2, dwRad5, 160);
		circlefill(pLight, -pIn->w/2, pIn->w/2, dwRad6, 192);
		circlefill(pLight, -pIn->w/2, pIn->w/2, dwRad7, 224);
		circlefill(pLight, -pIn->w/2, pIn->w/2, dwRad8, 255);
	}
	if(bSouth)
	{
		circlefill(pLight, pIn->w/2, pIn->w*3/2, dwRad1, 32);
		circlefill(pLight, pIn->w/2, pIn->w*3/2, dwRad2, 64);
		circlefill(pLight, pIn->w/2, pIn->w*3/2, dwRad3, 96);
		circlefill(pLight, pIn->w/2, pIn->w*3/2, dwRad4, 128);
		circlefill(pLight, pIn->w/2, pIn->w*3/2, dwRad5, 160);
		circlefill(pLight, pIn->w/2, pIn->w*3/2, dwRad6, 192);
		circlefill(pLight, pIn->w/2, pIn->w*3/2, dwRad7, 224);
		circlefill(pLight, pIn->w/2, pIn->w*3/2, dwRad8, 255);
	}
	if(bEast)
	{
		circlefill(pLight, pIn->w*3/2, pIn->w/2, dwRad1, 32);
		circlefill(pLight, pIn->w*3/2, pIn->w/2, dwRad2, 64);
		circlefill(pLight, pIn->w*3/2, pIn->w/2, dwRad3, 96);
		circlefill(pLight, pIn->w*3/2, pIn->w/2, dwRad4, 128);
		circlefill(pLight, pIn->w*3/2, pIn->w/2, dwRad5, 160);
		circlefill(pLight, pIn->w*3/2, pIn->w/2, dwRad6, 192);
		circlefill(pLight, pIn->w*3/2, pIn->w/2, dwRad7, 224);
		circlefill(pLight, pIn->w*3/2, pIn->w/2, dwRad8, 255);
	}

	gbInt dwColor, dwR, dwG, dwB, dwLight;
	for(int ly=0; ly<pIn->h; ly++)
	{
		for(int lx=0; lx<pIn->w; lx++)
		{
			dwLight = getpixel(pLight, lx, ly);
			dwLight = MID(0, dwLight, 255);
			dwLight = dwLight/2+128;
			dwColor = getpixel(pIn, lx, ly);
			dwR = getr(dwColor);
			dwG = getg(dwColor);
			dwB = getb(dwColor);

			putpixel(pOut, lx, ly, makecol(dwR*dwLight/255, dwG*dwLight/255, dwB*dwLight/255));
		}
	}

	destroy_bitmap(pLight);

	return pOut;
}
