#ifndef ERK_UNIT_H
#define ERK_UNIT_H

#define EU_MAX_UNITS			eu_dwMaxUnits

#define EU_UT_WORKER			0
#define EU_UT_SOLDIER_1			1
#define EU_UT_SOLDIER_2			2
#define EU_UT_SOLDIER_3			3
#define EU_UT_SOLDIER_4			4
#define EU_UT_COMMANDER			5
#define EU_UT_ADMIRAL			6
#define EU_UT_QUEEN				7
#define EU_UT_COUNT				8

extern gbInt eu_dwvMaxHealth[EU_UT_COUNT];
extern gbInt eu_dwvDamage[EU_UT_COUNT];
extern gbInt eu_dwvTileDamage[EU_UT_COUNT];
extern gbInt eu_dwMaxUnits;

class erkUnit {
public:
								erkUnit();
								~erkUnit();

	void						Draw(BITMAP* pDest, gbInt dwX, gbInt dwY);
	void						Move();

	void						SetTile(class erkTile* pTile);
	void						SetColor(gbInt dwColor);
	void						SetSide(gbBool bSide);

	class erkTile*				GetTile();
	gbInt						GetColor();
	gbBool						GetSide();

	void						IncHealth(gbInt dwAmount);
	void						DecHealth(gbInt dwAmount);

	void						SetType(gbInt dwType);
	gbInt						GetType();

	void						IncExp();
	void						AddVel(gbFloat fX, gbFloat fY);

protected:
	gbInt						m_dwType;
	gbInt						m_dwColor;
	gbBool						m_bSide;
	gbFloat						m_fvPos[2];
	gbFloat						m_fvVel[2];
	gbFloat						m_fvDest[2];
	gbInt						m_dwHealth;
	gbInt						m_dwExp;

	class erkTile*				m_pTile;

};
typedef erkUnit *erkUnit_p;

#endif // ERK_UNIT_H
