#ifndef ERK_TYPES_H
#define ERK_TYPES_H

#include <string>
#include <vector>
#include <list>
#include <map>

typedef int						gbInt, *gbInt_p;
typedef short					gbShort, *gbShort_p;
typedef char					gbChar, *gbChar_p;
typedef unsigned int			gbUInt, *gbUInt_p;
typedef unsigned short			gbUShort, *gbUShort_p;
typedef unsigned char			gbUChar, *gbUChar_p;
typedef bool					gbBool, *gbBool_p;
typedef float					gbFloat, *gbFloat_p;
typedef gbUChar					gbByte, *gbByte_p;
typedef void					*gbVoid_p;
typedef gbInt					gbResult, *gbResult_p;
typedef std::string				gbString, *gbString_p;
typedef gbString::iterator		gbStringIter, *gbStringIter_p;

#define gbList(t)				std::vector<t>
#define gbLinkList(t)			std::list<t>
#define gbIntMap(t)				std::map<const gbInt, t>
#define gbStringMap(t)			std::map<const std::string, t>
#define gbIntMultiMap(t)		std::multimap<const gbInt, t>
#define gbStringMultiMap(t)		std::multimap<const std::string, t>

#define gbListIter(t)			std::vector<t>::iterator
#define gbLinkListIter(t)		std::list<t>::iterator
#define gbIntMapIter(t)			std::map<const gbInt, t>::iterator
#define gbStringMapIter(t)		std::map<const std::string, t>::iterator
#define gbIntMultiMapIter(t)	std::multimap<const gbInt, t>::iterator
#define gbStringMultiMapIter(t)	std::multimap<const std::string, t>::iterator

#endif // ERK_TYPES_H
