#ifndef ERK_MAP_H
#define ERK_MAP_H

#include "erkTypes.h"
#include "erkUnit.h"
#include "erkCommand.h"
#include "erkTile.h"
#include "erkTTHive.h"
#include "erkTTTrainer.h"
#include "erkTTThorns.h"

#define EM_TILE_SIZE			32

class erkMap {
public:
								erkMap();
								~erkMap();

	void						Draw(BITMAP* pDest, gbInt dwX, gbInt dwY);
	void						Update();

	void						SetSize(gbInt dwWidth, gbInt dwHeight);
	void						SetTile(gbInt dwX, gbInt dwY, erkTile_p pTile);
	void						SetTile(gbInt dwX, gbInt dwY, erkTileType_p pType);
	void						SetTileLit(gbInt dwX, gbInt dwY, gbBool bLit);
	void						FillBlanks(erkTileType_p pType);

	virtual void				AddUnit(erkUnit_p pUnit);
	virtual void				RemoveUnit(erkUnit_p pUnit);

	gbBool						CheckLOS(gbInt dwX1, gbInt dwY1, gbInt dwX2, gbInt dwY2);

	void						Store(PACKFILE* pFile);
	void						Load(PACKFILE* pFile);

public: // Inlines
	inline erkTile_p			GetTile(gbInt dwX, gbInt dwY)
	{
		if(dwX < 0  ||  dwY < 0  ||  dwX >= m_dwvSize[0]  || dwY >= m_dwvSize[1])
			return NULL;
		return m_pvTiles[dwX+dwY*m_dwvSize[0]];
	}
	inline erkTile_p			GetTileEx(gbInt dwX, gbInt dwY)
	{
		return m_pvTiles[dwX+dwY*m_dwvSize[0]];
	}
	inline gbInt				GetUnitCount()
	{
		return m_pvUnits.size();
	}
	inline gbInt				GetTeamCount(gbBool bSide)
	{
		return m_dwvTeamCounts[bSide?1:0];
	}

	inline gbListIter(erkTile_p)	TilesBegin()
	{
		return m_pvTiles.begin();
	}
	inline gbListIter(erkTile_p)	TilesEnd()
	{
		return m_pvTiles.end();
	}

protected:
	gbInt						m_dwvSize[2];
	gbList(erkTile_p)			m_pvTiles;
	gbLinkList(erkUnit_p)		m_pvUnits;
	gbInt						m_dwvTeamCounts[2];

};
typedef erkMap *erkMap_p;

#endif // ERK_MAP_H
