#include <allegro.h>
#include <alfont.h>
#include "graphics.h"
#include "text.h"

#define MAX_FONTS 24
ALFONT_FONT *fonts[MAX_FONTS];

void LoadFonts(void)
{
  int i;

  alfont_init();

  for(i = 0; i < MAX_FONTS; i++)
    {
      fonts[i] = alfont_load_font("data/mecha.ttf");
      alfont_set_font_size(fonts[i], i);
    }
  alfont_text_mode(-1);
}

void DestroyFonts(void)
{
  int i;
  for(i = 0; i < MAX_FONTS; i++)
    {
      alfont_destroy_font(fonts[i]);
    }
  alfont_exit();
}

void Print(int size, int x, int y, int r, int g, int b, char *text)
{
  alfont_textout(back_buffer, fonts[size], text, x, y, makecol(r, g, b));
}

void PrintAA(int size, int x, int y, int r, int g, int b, char *text)
{
  alfont_textout_aa(back_buffer, fonts[size], text, x, y, makecol(r, g, b));
}
