#ifndef _SPRITE_H
#define _SPRITE_H

#include <allegro.h>

class SPRITE
{
 protected:
  BITMAP *data; //Bitmap data.
  BITMAP *dest; //Destination bitmap.
  bool mask; //Masking on / off.
  int width; //Blit width.
  int height; //Blit height.
  int source_x; //Upper left-hand corner.
  int source_y; //Lower right_hand corner.
 public:
  SPRITE();
  ~SPRITE();

  //Load a PNG file.
  void CreateBitmap(int new_width, int new_height, int bpp); //Create an empty bitmap.  Set bpp to 0 for auto-select.
  void Clear32(int r, int g, int b, int a);
  void Clear(int r, int g, int b);
  void LoadPNG(char *filename, bool convert); //Load a PNG file.
  void Destroy(void); //Destroy the bitmap data.
  void Display(int x, int y); //Display at x, y.
  void DisplayAlpha(int x, int y); //Display using alpha values.
  void DisplayTransparent(int x, int y, int alpha); //Transparent.
  void DisplayStretch(int x, int y, int size_x, int size_y); //Stretches
  void DisplayRotate(int x, int y, double angle); //Rotates. 
  void DisplayRotozoom(int x, int y, double angle, double scale); //Rotozoom
  void DisplayTinted(int x, int y, int r, int g, int b, int a); //Tint it.
  void SetMask(bool mask_on); //Turn masking on / off (default on)
  void SetBlitWidth(int new_width); //Width of blitting (for cropping) .
  void SetBlitHeight(int new_height); //Height of blitting (for cropping).
  void SetBlitUpperXOffset(int upper_x); //Upper X offset (usually 0).
  void SetBlitUpperYOffset(int upper_y); //Upper Y offset (usually 0).
  void ResetWidthHeightXYOffsets(void); //Resets width heigh source_x/y.
  BITMAP *GetBitmapPtr(void); //Returns the bitmap pointer.
  void SetDestination(BITMAP *destination); //Sets the destination bitmap.
  void ResetDestination(void); //Resets the destination bitmap to back_buffer.
};

//Uses RLE data for faster blits, but not as comprehensive.
class SIMPLE_SPRITE
{
 private:
  RLE_SPRITE *data;
  BITMAP *dest;
 public:
  SIMPLE_SPRITE();
  ~SIMPLE_SPRITE();
  void Convert(SPRITE &source); //Converts a sprite to a SIMPLE_SPRITE.
  void Destroy(void); //Destroys the data.
  void Display(int x, int y);
  void DisplayAlpha(int x, int y);
  void DisplayTrans(int x, int y, int a);
  void DisplayTinted(int x, int y, int r, int g, int b, int a);
  void SetDestination(BITMAP *destination); //Sets the destination bitmap.
  void ResetDestination(void); //Resets the destination bitmap to back_buffer.
};

#endif
