#ifndef _SOUND_H
#define _SOUND_H

#ifdef LINUX
#include "fmodlin/fmod.h"
#else
#include "fmodwin/fmod.h"
#endif

class SOUNDSAMPLE
{
 private:
  FSOUND_SAMPLE *sample;
  int playback_channel;
 public:
  SOUNDSAMPLE(void) { sample = NULL; playback_channel = -1; }
  ~SOUNDSAMPLE(void) { FSOUND_Sample_Free(sample); sample = NULL; }
  void Load(char *filename);
  void Destroy(void);
  void Play(void);
  void SetRepeat(bool on);
  void Stop(void);
};

class STREAM
{
 private:
  FSOUND_STREAM *stream;
  int playback_channel;
 public:
  STREAM();
  ~STREAM();
  void Load(char *filename);
  void Destroy(void);
  void Play(void);
  void SetRepeat(bool on);
  void Stop(void);
};
int SetupSound(void);

#endif
