#include <allegro.h>
#include "input.h"

bool BUTTON_UP_DOWN;
bool BUTTON_DOWN_DOWN;
bool BUTTON_LEFT_DOWN;
bool BUTTON_RIGHT_DOWN;
bool BUTTON_A_DOWN;
bool BUTTON_ESC_DOWN;
bool BUTTON_UP_PREV;
bool BUTTON_DOWN_PREV;
bool BUTTON_LEFT_PREV;
bool BUTTON_RIGHT_PREV;
bool BUTTON_A_PREV;
bool BUTTON_ESC_PREV;

int SetupInput(void)
{
  if(install_keyboard())
    {
      allegro_message("Could not install keyboard!");
      return 1;
    }

  //Switch into polling mode.
  poll_keyboard();

  //Disable repeats.
  set_keyboard_rate(0, 0);

  BUTTON_UP_DOWN = false;
  BUTTON_DOWN_DOWN = false;
  BUTTON_LEFT_DOWN = false;
  BUTTON_RIGHT_DOWN = false;
  BUTTON_A_DOWN = false;
  BUTTON_UP_PREV = false;
  BUTTON_DOWN_PREV = false;
  BUTTON_LEFT_PREV = false;
  BUTTON_RIGHT_PREV = false;
  BUTTON_A_PREV = false;
  BUTTON_ESC_DOWN = false;
  BUTTON_ESC_PREV = false;

  return 0;
}

void UpdateInput(void)
{
  BUTTON_UP_PREV = BUTTON_UP_DOWN;
  BUTTON_DOWN_PREV = BUTTON_DOWN_DOWN;
  BUTTON_LEFT_PREV = BUTTON_LEFT_DOWN;
  BUTTON_RIGHT_PREV = BUTTON_RIGHT_DOWN;
  BUTTON_A_PREV = BUTTON_A_DOWN;
  BUTTON_ESC_PREV = BUTTON_ESC_DOWN;

  poll_keyboard();

  //Button up!
  if(key[KEY_8_PAD] || key[KEY_UP] || key[KEY_W])
    {
      BUTTON_UP_DOWN = true;
    }
  else
    {
      BUTTON_UP_DOWN = false;
    }

  //Button down!
  if(key[KEY_2_PAD] || key[KEY_DOWN] || key[KEY_S])
    {
      BUTTON_DOWN_DOWN = true;
    }
  else
    {
      BUTTON_DOWN_DOWN = false;
    }

  //Button left!
  if(key[KEY_4_PAD] || key[KEY_LEFT] || key[KEY_A])
    {
      BUTTON_LEFT_DOWN = true;
    }
  else
    {
      BUTTON_LEFT_DOWN = false;
    }

  //Button right!
  if(key[KEY_6_PAD] || key[KEY_RIGHT] || key[KEY_D])
    {
      BUTTON_RIGHT_DOWN = true;
    }
  else
    {
      BUTTON_RIGHT_DOWN = false;
    }

  //Button A!
  if(key[KEY_SPACE] || (key_shifts & KB_CTRL_FLAG) || key[KEY_ENTER])
    {
      BUTTON_A_DOWN = true;
    }
  else
    {
      BUTTON_A_DOWN = false;
    }

  //Escape button.
  if(key[KEY_ESC])
    {
      BUTTON_ESC_DOWN = true;
    }
  else
    {
      BUTTON_ESC_DOWN = false;
    }
}


bool ButtonUpPress(void)
{
  return (!BUTTON_UP_PREV && BUTTON_UP_DOWN);
}

bool ButtonUpDown(void)
{
  return BUTTON_UP_DOWN;
}

bool ButtonDownPress(void)
{
  return (!BUTTON_DOWN_PREV && BUTTON_DOWN_DOWN);
}

bool ButtonDownDown(void)
{
  return BUTTON_DOWN_DOWN;
}

bool ButtonLeftPress(void)
{
  return (!BUTTON_LEFT_PREV && BUTTON_LEFT_DOWN);
}

bool ButtonLeftDown(void)
{
  return BUTTON_LEFT_DOWN;
}

bool ButtonRightPress(void)
{
  return (!BUTTON_RIGHT_PREV && BUTTON_RIGHT_DOWN);
}

bool ButtonRightDown(void)
{
  return BUTTON_RIGHT_DOWN;
}

bool ButtonAPress(void)
{
  return (!BUTTON_A_PREV && BUTTON_A_DOWN);
}

bool ButtonADown(void)
{
  return BUTTON_A_DOWN;
}

bool ButtonEscPress(void)
{
  return (!BUTTON_ESC_PREV && BUTTON_ESC_DOWN);
}

bool ButtonEscDown(void)
{
  return BUTTON_ESC_DOWN;
}
