#ifndef _GAME_H
#define _GAME_H

#include "sprite.h"
#include "scene.h"
#include "vectors.h"
#include "sound.h"

#define MAX_MAPS 200
#define MAX_TILES 20
#define MAX_ENEMIES 150

enum DIRECTION { UP, DOWN, LEFT, RIGHT };

void RunGame(void);

class ENEMY
{
 private:
  double x;
  double y;
  double aniframe;
  int goalx; //For AI.
  int goaly; 
  bool alive;
  int speed;
 public:
  int GetX(void) { return (static_cast<int>(x)); }
  int GetY(void) { return (static_cast<int>(y)); }
  void Init(int new_speed); //Creates a new one at a random location on the map.
  void Destroy(void); //Should be usefull for killing / initializing.
  void UpdateAI(void);
  void Display(int alpha);
  bool Alive(void) { return alive; }
};

class PLAYER
{
 private:
  SIMPLE_SPRITE sprites[10];
  SPRITE attack_sprite;
  VECTOR invincible;
  double x;
  double y;
  double aniframe;
  double attack_angle;
  int hp;
  int max_hp;
  int level;
  int exp;
  int level_up_exp;
  DIRECTION facing;
  int status;
  bool moving;
  bool attacking;
  void UpdateAnimationFrame(void);
 public:
  void SetMoving(bool move);
  void SetXY(int new_x, int new_y);
  void Draw(void);
  void LoadArt(void);
  void ReleaseArt(void);
  void MoveUp(void);
  void MoveDown(void);
  void MoveLeft(void);
  void MoveRight(void);
  void Attack(void);
  int GetX(void) { return static_cast<int>(x); }
  int GetY(void) { return static_cast<int>(y); }
  int GetTileX(void);
  int GetTileY(void);
  bool Attacking(void) { return attacking; }
  double GetAttackAngle(void) { return attack_angle; }
  DIRECTION GetFacing(void) { return facing; }
  void DisplayHP(void);
  void ReduceHP(void);
  void AddHP(void);
  void SetHP(int new_hp) { hp = new_hp; }
  int GetHP(void) { return hp; }
  int GetMaxHP(void) { return max_hp; }
  void SetInvincible(void) { invincible.Set(1, -2); }
  void ResetPlayer(void);
  double GetInvincible(void) { return invincible.GetValue(); }
  void AddEXP(int amount);
};

struct MAP
{
  int tiles[20][15];
  int tiles_alpha[20][15];
  ENEMY enemies[MAX_ENEMIES];
  int tile_exit_x;
  int tile_exit_y;
  int tile_enterance_x;
  int tile_enterance_y;
  bool final_room;
  int num_enemies;
  int difficulty;
};

class GAME : public SCENE
{
 private:
  MAP maps[MAX_MAPS];
  DIRECTION path[MAX_MAPS]; 
  int current_room;
  SPRITE tiles[MAX_TILES];
  PLAYER player;
  SPRITE black;
  VECTOR fade;
  SOUNDSAMPLE swing;
  SOUNDSAMPLE hit;
  SOUNDSAMPLE life_down;
  SOUNDSAMPLE ding;
  int difficulty;
  int num_maps;
  int min_enem;
  int max_enem;
  int enem_speed_min;
  int enem_speed_max;
  bool beaten;
  bool dungeon_complete;
 public:
  bool OnWinningQuad(void);
  void SetVariables(int min_enemies, int max_enemies, int enemy_speed_min, int enemy_speed_max, int maps);
  void ResetGame(void); 
  void DrawEnemies(int map_number);
  void CheckAttackCollision(int map_number);
  void CheckCollisionHit(int map_number);
  void CheckExitCollisions(void);
  void GoNextRoom(void);
  void GoPrevRoom(void);
  void SetVars(int dif, int maps);
  void DrawTextBox(char *text);
  void GenerateMaps(void); //Generates the paths and the rooms.
  void DrawMap(int map_num);
  void Pause(void);
  void UnPause(void);
  virtual void Setup(void);
  virtual void GameLoop(void);
  virtual void Cleanup(void);
  int EnemiesLeftInMap(int map_number);
  int EnemiesLeft(void);
  void CheckCompleteness(void);
  void CreateExitWarp(void);
};

#endif
