#include <allegro.h>
#include <cstdio>
#include "ddisplay.h"
#include "text.h"
#include "input.h"
#include "graphics.h"

void DUNGEON_DISPLAY::SetFiends(int fiends_left)
{
  fiends = fiends_left;
}

void DUNGEON_DISPLAY::SetLevel(int level)
{
  dungeon_level = level;
}

void DUNGEON_DISPLAY::Setup(void)
{
  char *print_me;

  print_me = new char[40];
  text_sprite.CreateBitmap(320, 80, 0);
  
  text_sprite.Clear(0, 0, 0);

  sprintf(print_me, "Area: %d", dungeon_level + 1);
  alfont_textout_centre_aa(text_sprite.GetBitmapPtr(), fonts[20], print_me, 160, 10, makecol(255, 255, 255));

  sprintf(print_me, "Fiends: %d", fiends);
  alfont_textout_centre_aa(text_sprite.GetBitmapPtr(), fonts[14], print_me, 160, 30, makecol(255, 255, 255));

  alpha.Set(600, -255);

  delete[] print_me;
}

void DUNGEON_DISPLAY::Cleanup(void)
{
  text_sprite.Destroy();
}

void DUNGEON_DISPLAY::GameLoop(void)
{
  ClearScreen();
  int a = alpha.GetIntValue();

  if(a > 255)
    a = 255;
  text_sprite.DisplayTransparent(0, 100, a);
  alpha.Update();
  
  if(alpha.GetValue() <= 0 || ButtonAPress() || ButtonEscPress())
    {
      EndScene(0);
    }
}
