#include <allegro.h>
#include "timer.h"

//The lowest frames per second allowable.
#define LOWEST_FPS 15

void TimerFunc(void);

volatile unsigned int timer;
unsigned int previous_timer;
double frame_time;

//Called every millisecond or 1,000 times a second.  
void TimerFunc(void)
{
  timer++;
}
END_OF_FUNCTION(TimerFunc)

int SetupTimer(void)
{
  //First we need to install the timer...
  if(install_timer())
    {
      allegro_message("Could not install timer!");
      return 1;
    }

  //Reset the timer.
  timer = 0;

  //I aparently have to lock these, whatever that means.  I trust blindly.  =)
  LOCK_VARIABLE(timer);
  LOCK_FUNCTION(TimerFunc);

  //Now I TimerFunc will be called every millisecond.
  if(install_int(TimerFunc, 1))
    {
      allegro_message("Could not install timer interrupt!");
      return 1;
    }

  ResetFrameTime();
  return 0;
}

void UpdateFrameTime(void)
{
  int diff;
  
  if(timer < previous_timer)
    {
      diff = timer;
    }
  else
    {
      diff = timer - previous_timer;
    }

  /*if(diff > (LOWEST_FPS / 1000))
    {
      diff = (LOWEST_FPS / 1000);
      }*/

  previous_timer = timer;

  frame_time = static_cast<double>(diff) / 1000.00;
}

void ResetFrameTime(void)
{
  previous_timer = timer;  
}
