#include <allegro.h>
#include "sound.h"
#ifdef LINUX
#include "fmodlin/fmod.h"
#else
#include "fmodwin/fmod.h"
#endif

int SetupSound(void)
{
  int result;
#ifdef LINUX
  result = FSOUND_Init(44100, 64, 0);
#else
  result = FSOUND_Init(44100, 64, FSOUND_INIT_DSOUND_DEFERRED);
#endif

  if(!result)
    {
      allegro_message("Could not initialize sound.");
      return 1;
    }

  return 0;
}

void SOUNDSAMPLE::Load(char *filename)
{
  sample = FSOUND_Sample_Load(FSOUND_UNMANAGED, filename, FSOUND_LOOP_OFF | FSOUND_NORMAL, 0, 0);  
}

void SOUNDSAMPLE::Destroy(void)
{
  FSOUND_Sample_Free(sample);
  sample = NULL;
}

void SOUNDSAMPLE::Play(void)
{
  if(sample)
    {
      playback_channel = FSOUND_PlaySound(FSOUND_FREE, sample);
    }
}

void SOUNDSAMPLE::SetRepeat(bool on)
{
  if(sample)
    {
      if(on)
	FSOUND_Sample_SetMode(sample, FSOUND_LOOP_NORMAL);
      else
	FSOUND_Sample_SetMode(sample, FSOUND_LOOP_OFF);

    }
}

void SOUNDSAMPLE::Stop(void)
{
  if(sample && playback_channel >= 0)
    {
      FSOUND_StopSound(playback_channel);
    }
}

FSOUND_STREAM *stream;
int playback_channel;

STREAM::STREAM()
{
  stream = NULL;
  playback_channel = -1;
}

STREAM::~STREAM()
{
  Destroy();
}

void STREAM::Load(char *filename)
{
  stream = FSOUND_Stream_Open(filename, FSOUND_LOOP_NORMAL, 0, 0);
}

void STREAM::Destroy(void)
{
  if(stream)
    {
      FSOUND_Stream_Close(stream);
      stream = NULL;
    }
}

void STREAM::Play(void)
{
  playback_channel = FSOUND_Stream_Play(FSOUND_FREE, stream);
}

void STREAM::SetRepeat(bool on)
{
  if(stream)
    {
      if(on)
	FSOUND_Stream_SetMode(stream,FSOUND_LOOP_NORMAL);
      else
	FSOUND_Stream_SetMode(stream,FSOUND_LOOP_OFF);
    }
}

void STREAM::Stop(void)
{
  FSOUND_Stream_Stop(stream);
}
