#include <allegro.h>
#include "menu.h"
#include "sound.h"
#include "sprite.h"
#include "vectors.h"
#include "input.h"
#include "text.h"
#include "graphics.h"

#define TEXT_X 120
#define TEXT_Y 160

void MAIN_MENU::Setup(void)
{
  selector.LoadPNG("data/bselect.png", false);
  background.LoadPNG("data/menubg.png", true);
  spun_selector.CreateBitmap(16, 16, 32);
  black.CreateBitmap(320,240,0);
  black.Clear(0,0,0);
  selector.SetDestination(spun_selector.GetBitmapPtr());
  music.Load("data/intro.mp3");
  music.Play();

  alpha.Set(255, -200);
  spin.Set(0, 360);
  AddToVectorList(&spin);
  selection = 1;
}

void MAIN_MENU::GameLoop(void)
{
  ClearScreen();
  if(ButtonEscPress())
    {
      EndScene(0);
    }

  if(ButtonDownPress())
    {
      if(selection < 3)
	{
	  selection++;
	}
    }

  if(ButtonUpPress())
    {
      if(selection > 1)
	{
	  selection--;
	}
    }
  if(ButtonAPress())
    {
      EndScene(selection);
    }

  background.Display(0,0);

  if(selection == 1)
    {
      PrintAA(16, TEXT_X, TEXT_Y, 255, 255, 255, "New Game");
    }
  else
    {
      PrintAA(16, TEXT_X, TEXT_Y, 128, 128, 255, "New Game");
    }
  if(selection == 2)
    {
      PrintAA(16, TEXT_X, TEXT_Y + 18, 255, 255, 255, "Full/Window");
    }
  else
    {
      PrintAA(16, TEXT_X, TEXT_Y + 18, 128, 128, 255, "Full/Window");
    }
  if(selection == 3)
    {
      PrintAA(16, TEXT_X, TEXT_Y + 36, 255, 255, 255, "Quit");
    }
  else
    {
      PrintAA(16, TEXT_X, TEXT_Y + 36, 128, 128, 255, "Quit");
    }

  spun_selector.Clear32(0,0,0,1);
  selector.DisplayRotate(0, 0, spin.GetValue());
  spun_selector.DisplayAlpha(TEXT_X - 20, TEXT_Y + ((selection - 1)*18));

  if(spin.GetValue() > 360)
    {
      spin.SetValue(spin.GetValue() - 360);
    }
  if(alpha.GetValue() > 1)
    {
      black.DisplayTransparent(0,0,alpha.GetIntValue());
      alpha.Update();
    }
}

void MAIN_MENU::Cleanup(void)
{
  RemoveFromVectorList(&spin);
  background.Destroy();
  spun_selector.Destroy();
  selector.Destroy();
  black.Destroy();
  music.Stop();
  music.Destroy();
}

MAIN_MENU::~MAIN_MENU(void)
{
  selector.Destroy();
  music.Destroy();
}
