#include <iostream>
#include <allegro.h>
#include <cstdlib>
#include <ctime>
#include "game.h"
#include "graphics.h"
#include "timer.h"
#include "sound.h"
#include "input.h"
#include "menu.h"
#include "text.h"

using namespace std;

int main(void)
{
  MAIN_MENU menu;
  int select;

  srand (time(NULL));

  if(allegro_init() != 0)
    {
      allegro_message("Could not init allegro!");
      return 1;
    }

  if(SetupInput())
    {
      remove_keyboard();
      allegro_exit();
      return 1;
    }

  if(SetupTimer())
    {
      remove_keyboard();
      remove_timer();
      allegro_exit();
      return 1;
    }
 
  if(SetupSound())
    {
      remove_keyboard();
      FSOUND_Close();
      remove_timer();
      allegro_exit();
      return 1;
    }

  if(SetupGraphics())
    {
      remove_keyboard();
      FSOUND_Close();
      remove_timer();  
      allegro_exit();
      return 1;
    }

  LoadFonts();
  
  select = 1;

  while(select != 3 && select != 0)
    {
      select = menu.DoScene();
      if(select == 1)
	{
	  RunGame();
	}
      if(select == 2)
	{
	  SwitchScreenModes();
	}
    }

  DestroyFonts();
  
  remove_keyboard();
  DestroyGraphics();
  FSOUND_Close();
  remove_timer();  
  allegro_exit();
  return 0;
}
END_OF_MAIN()
