#include <vector>
#include "vectors.h"
#include "timer.h"

using namespace std;

vector<VECTOR *> vector_list;

void AddToVectorList(VECTOR *new_vector)
{
  if(!InVectorList(new_vector))
    vector_list.push_back(new_vector);
}

bool InVectorList(VECTOR *old_vector)
{
  vector<VECTOR *>::iterator iter;

  iter = vector_list.begin();

  while(iter != vector_list.end())
    {
      if((*iter) == old_vector)
	return true;
      iter++;
    }
  return false;
}

void UpdateVectorList(void)
{
  vector<VECTOR *>::iterator iter;

  iter = vector_list.begin();

  while(iter != vector_list.end())
    {
      (*iter)->Update();
      iter++;
    }
}

void RemoveFromVectorList(VECTOR *byebye_vector)
{
  vector<VECTOR *>::iterator iter;

  iter = vector_list.begin();

  while(iter != vector_list.end())
    {
      if((*iter) == byebye_vector)
	{
	  vector_list.erase(iter);
	  return;
	}
      iter++;
    }
  
}

void VECTOR::SetValue(double new_value)
{
  value = new_value;
}

void VECTOR::SetValue(int new_value)
{
  value = static_cast<double>(new_value);
}

double VECTOR::GetValue(void)
{
  return value;
}

int VECTOR::GetIntValue(void)
{
  return static_cast<int>(value);
}

void VECTOR::SetCPS(double new_change)
{
  cps = new_change;
}

void VECTOR::SetCPS(int new_change)
{
  cps = static_cast<double>(new_change);
}

double VECTOR::GetCPS(void)
{
  return cps;
}

void VECTOR::Set(double new_value, double change)
{
  value = new_value;
  cps = change;
}

void VECTOR::Update(void)
{
  value+= frame_time * cps;
}
