#include <allegro.h>
#include <loadpng.h>
#include "sprite.h"
#include "graphics.h"

SPRITE::SPRITE()
{
  data = NULL;
  mask = true;
}

SPRITE::~SPRITE()
{
  if(data)
    {
      destroy_bitmap(data);
    }
}

void SPRITE::CreateBitmap(int new_width, int new_height, int bpp)
{
  if(data)
    {
      Destroy();
    }
  
  if(bpp == 0)
    data = create_bitmap(new_width, new_height);
  else
    data = create_bitmap_ex(bpp, new_width, new_height);

  if(data)
    {
      ResetWidthHeightXYOffsets();
      ResetDestination();
    }
}

void SPRITE::Clear32(int r, int g, int b, int a)
{
  if(data)
    {
      clear_to_color(data, makeacol32(r, g, b, a));
    }
}

void SPRITE::Clear(int r, int g, int b)
{
  if(data)
    {
      clear_to_color(data, makecol(r, g, b));
    }
}

void SPRITE::LoadPNG(char *filename, bool convert)
{
  if(!convert)
    set_color_conversion(COLORCONV_NONE);

  data = load_png(filename, NULL);
  if(data)
    {
      ResetWidthHeightXYOffsets();
      ResetDestination();
    }

  if(!convert)
    set_color_conversion(COLORCONV_TOTAL);
}

void SPRITE::Destroy(void)
{
  destroy_bitmap(data);
  data = NULL;
}

void SPRITE::SetMask(bool mask_on)
{
  mask = mask_on;
}
 
void SPRITE::Display(int x, int y)
{
  if(data && dest)
    {
      if(mask)
	{
	  masked_blit(data, dest, source_x, source_y, x, y, width, height);
	}
      else
	{
	  blit(data, dest, source_x, source_y, x, y, width, height);
	}
    }
}

void SPRITE::DisplayAlpha(int x, int y)
{
  if(data && dest)
    {
      set_alpha_blender();
      draw_trans_sprite(dest, data, x, y);
    }
}

void SPRITE::DisplayTransparent(int x, int y, int alpha)
{
  if(data && dest)
    {
      set_trans_blender(0, 0, 0, alpha);
      draw_trans_sprite(dest, data, x, y);
    }
}

void SPRITE::DisplayStretch(int x, int y, int size_x, int size_y)
{
  if(data && dest)
    {
      if(mask)
	{
	  masked_stretch_blit(data,dest , source_x, source_y, width, height, x, y, size_x, size_y);
	}
      else
	{
	  stretch_blit(data, dest, source_x, source_y, width, height, x, y, size_x, size_y);
	}
    }
}

void SPRITE::DisplayRotate(int x, int y, double angle)
{
  if(data && dest)
    {
      rotate_sprite(dest, data, x, y, ftofix(angle));
    }
}
  
void SPRITE::DisplayRotozoom(int x, int y, double angle, double scale)
{
  if(data && dest)
    {
      rotate_scaled_sprite(dest, data, x, y, ftofix(angle), ftofix(scale));
    }
}

void SPRITE::DisplayTinted(int x, int y, int r, int g, int b, int a)
{
  if(data && dest)
    {
      set_trans_blender(r, g, b, 0);
      draw_lit_sprite(dest, data, x, y, a);
    }
}

void SPRITE::SetBlitWidth(int new_width)
{
  width = new_width;
}

void SPRITE::SetBlitHeight(int new_height)
{
  height = new_height;
}

void SPRITE::SetBlitUpperXOffset(int upper_x)
{
  source_x = upper_x;
}

void SPRITE::SetBlitUpperYOffset(int upper_y)
{
  source_y = upper_y;
}

void SPRITE::ResetWidthHeightXYOffsets(void)
{
  source_x = 0;
  source_y = 0;
  
  if(data)
    {
      width = data->w;
      height = data->h;
    }
}

BITMAP *SPRITE::GetBitmapPtr(void)
{
  return data;
}

void SPRITE::SetDestination(BITMAP *destination)
{
  dest = destination;
}

void SPRITE::ResetDestination(void)
{
  dest = back_buffer;
}

SIMPLE_SPRITE::SIMPLE_SPRITE()
{
  data = NULL;
}

SIMPLE_SPRITE::~SIMPLE_SPRITE()
{
  Destroy();
}

void SIMPLE_SPRITE::Convert(SPRITE &source)
{
  if(source.GetBitmapPtr() != NULL)
    {
      data = get_rle_sprite(source.GetBitmapPtr());
      dest = back_buffer;
    }
}

void SIMPLE_SPRITE::Destroy(void)
{
  if(data)
    {
      destroy_rle_sprite(data);
      data = NULL;
    }
}

void SIMPLE_SPRITE::Display(int x, int y)
{
  if(data && dest)
    {
      draw_rle_sprite(dest, data, x, y);
    }
}

void SIMPLE_SPRITE::DisplayAlpha(int x, int y)
{
  if(data && dest)
    {
      set_alpha_blender();
      draw_trans_rle_sprite (dest, data, x, y);
    }
}

void SIMPLE_SPRITE::DisplayTrans(int x, int y, int a)
{
  if(data && dest)
    {
      set_trans_blender(0, 0, 0, a);
      draw_trans_rle_sprite(dest, data, x, y);
    }
}

void SIMPLE_SPRITE::DisplayTinted(int x, int y, int r, int g, int b, int a)
{
  if(data && dest)
    {
      set_trans_blender(r, g, b, 0);
      draw_lit_rle_sprite(dest, data, x, y, a);
    }
}

void SIMPLE_SPRITE::SetDestination(BITMAP *destination)
{
  dest = destination;
}

void SIMPLE_SPRITE::ResetDestination(void)
{
  dest = back_buffer;
}
