/**********************************************/
/* Miscellaneous routines and settings        */
/* Evert Glebbeek 2002, 2003, 2004            */
/* eglebbk@dds.nl                             */
/**********************************************/
#include <allegro.h>
#include <allegro/internal/aintern.h>
#include <string.h>
#include <stdio.h>
#include "global.h"

INT_SETTINGS settings = {
   16, 800, 600, 800, 1800,
   WINDOWED_MODE + DOUBLE_BUFFER + MUSIC_MIDI + SFX_DIGI,
   16,
   0,0,0,0,0,0,0,

   0,
   
   15
};

volatile int close_button_pressed = 0;

/* Game working directory and scratch buffer for expanding file names */
static char game_directory[4096] = "./";
static char game_filepath[4096] = "";

/* Clip a number between two values */
int clip_num(const int x, const int min, const int max)
{
   /*
   int n;
   n = ~min;
   n &= (~n)>>31;
   n+=min;
   n-=max;
   n&=n>>31;
   n+=max;
   return n;
   */
   return (x<=min)?min:((x>=max)?max:x);
}

/* Get the sign of x */
int sgn(int x)
{
   if (x > 0)
      return 1;
   else if (x < 0)
      return -1;
   else
      return 0;
}

/* Returns true if n is a power of 2 */
int is_power_of_two(const int n)
{
   return !(n & (n-1));
}

/* Returns TRUE if (x, y) falls within the rectangle (rx,ry)-(rx+rw,rx+rh) */
/* Point on the edge are supposed to belong to the rectangle */
/* The split up of the if statement results in slightly faster code (gprof) */
int in_rect(int x, int y, int rx, int ry, int rw, int rh)
{
   if (x < rx)
      return FALSE;
   if (y < ry)
      return FALSE;
   if (x > rx + rw)
      return FALSE;
   if (y > ry + rh)
      return FALSE;

   return TRUE;

/*
   if (x >= rx && x <= rx + rw && y >= ry && y <= ry + rh)
      return TRUE;
   else
      return FALSE;
*/
}

/* Returns TRUE if the first rectangle lies within the second */
int rect_contains(int rx1, int ry1, int rw1, int rh1,
                  int rx2, int ry2, int rw2, int rh2)
{
   if (rx1 >= rx2 && ((rx1 + rw1) <= (rx2 + rw2)) &&
       ry1 >= ry2 && ((ry1 + rh1) <= (ry2 + rh2)))
      return TRUE;
   else
      return FALSE;
}

/* Returns TRUE if the two rectangles overlap */
int rect_overlap(int rx1, int ry1, int rw1, int rh1, int rx2, int ry2,
                 int rw2, int rh2)
{
   return (in_rect(rx1, ry1, rx2, ry2, rw2, rh2) ||
           in_rect(rx1 + rw1, ry1, rx2, ry2, rw2, rh2) ||
           in_rect(rx1, ry1 + rh1, rx2, ry2, rw2, rh2) ||
           in_rect(rx1 + rw1, ry1 + rh1, rx2, ry2, rw2, rh2) ||
           in_rect(rx2, ry2, rx1, ry1, rw1, rh1) ||
           in_rect(rx2 + rw2, ry2, rx1, ry1, rw1, rh1) ||
           in_rect(rx2, ry2 + rh2, rx1, ry1, rw1, rh1) ||
           in_rect(rx2 + rw2, ry2 + rh2, rx1, ry1, rw1, rh1));
}

/* Returns the distance (squared) between points (x1, y1) and (x2, y2) */
int distsqr(int x1, int y1, int x2, int y2)
{
   return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
}

/* Get the current directory (and drive) */
void get_current_dir(char *dir, int len)
{
#if (DEVICE_SEPARATOR != 0) && (DEVICE_SEPARATOR != '\0')
   int drive = _al_getdrive();
#else
   int drive = 0;
#endif

   _al_getdcwd(drive, dir, len - ucwidth(OTHER_PATH_SEPARATOR));
}

/* Set the path to the game datafiles */
void set_game_directory(const char *dir)
{
   sprintf(game_directory, dir);
   put_backslash(game_directory);
}

/* Get the absolute path of a file within the game directory */
char *get_game_path(const char *filename)
{
   #if defined ALLEGRO_UNIX
   if (filename[0] == '/')
      sprintf(game_filepath, "%s", filename);
   else
   #elif defined ALLEGRO_WINDOWS || defined ALLEGRO_DOS
   if (filename[1] == ':')
      sprintf(game_filepath, "%s", filename);
   else
   #endif
   sprintf(game_filepath, "%s%s", game_directory, filename);
   return game_filepath;
}

/* returns TRUE if a joystick button is being held down */
int joystick_button(void)
{
   int c;
   int n;

   if (num_joysticks) {
      poll_joystick();
      for (n=0; n<num_joysticks; n++) {
         for (c=0; c<joy[n].num_buttons; c++) {
            if (joy[n].button[c].b) {
               return TRUE;
            }
         }
      }
   }
   return FALSE;
}
