#ifndef NETWORK_H
#define NETWORK_H

#define MAX_CLIENTS  8

extern void network_init(char *configfile);
extern int get_nr_network_drivers(void);
extern char *get_network_driver_name(int n);

extern int start_server(int driver_nr);
extern void shutdown_server(void);
extern int server_listen(void);
extern int server_receive(void *data, int *sender);
extern int server_send(void *data, int len, int whom);
extern int server_send_all(void *data, int len);

extern void server_disconnect_client(int whom);

extern int start_client(const char *serveraddress, const int driver_nr);
extern void shutdown_client(void);
extern int client_is_connected(void) ;
extern int client_receive(void *data);
extern int client_send(void *data, int len);

#endif
