#ifndef LINKED_H
#define LINKED_H

typedef struct LINK {
   struct LINK *next;
   struct LINK *prev;
   void *data;
} LINK;

extern LINK *alloc_link(void);
extern void free_link(LINK *l);

extern int get_link_count(void);

extern int init_lists(void);
extern void free_lists(void);

extern LINK *duplicate_list(LINK *list);
extern void destroy_list(LINK *list, void (*free_data)(void *));

extern int in_list(const LINK *list, const void *d);
extern LINK *add_to_list(void *data, LINK *list);
extern LINK *append_to_list(void *data, LINK *list);
extern LINK *merge_list(LINK *c, LINK *list, int (*sorter)(const void *, const void *));
extern LINK *remove_from_list(void *data, LINK *list);
extern int get_list_length(LINK *list);

/* The filter_list function can filter a list based on some reference function and return a copy of those items in the list that pass the test */
extern LINK *filter_list(LINK *list, int (*filter)(void *));
#endif
