#ifndef GLOBAL_H
#define GLOBAL_H

typedef struct INT_SETTINGS {
   int colour_depth;
   int width;
   int height;

   int virtual_width;
   int virtual_height;

   int flags;

   int gamekey_buffer_size;

   int gl_colour_depth;
   int gl_z_depth;
   int gl_width;
   int gl_height;
   float gl_z_far;
   int gl_viewport_width;  /* In integer fractions! 1024 -> 1 */
   int gl_texture_res;
   
   int window_close_button;
   
   int lowest_colour_depth;
} INT_SETTINGS;
/* Interface light settings */
/* The 'raw' setting is for internal use only and can't be selected by user */
#define LIT_PLAIN          (1<<0)
#define LIT_GOURAUD        (1<<1)
#define LIT_RAW            (1<<2)
/* Screen update modes */
#define DOUBLE_BUFFER      (1<<3)
#define PAGE_FLIP          (1<<4)
#define IMMEDIATE          (1<<5)
#define TRIPLE_BUFFER      (1<<6)
#define DIRTY_RECTANGLE    (1<<7)
#define MAP_EDIT           (1<<8)
#define USE_RLES           (1<<9)
#define USE_BMPS           (1<<10)
/* Sound options */
#define MUSIC_CD           (1<<11)
#define MUSIC_MIDI         (1<<12)
#define SFX_DIGI           (1<<13)
/* Screen-options: windowed mode */
#define HARD_SCROLLING     (1<<14)
#define WINDOWED_MODE      (1<<15)


extern INT_SETTINGS settings;
extern volatile int close_button_pressed;

/* Function prototypes */
/* Returns TRUE if (x, y) falls within the rectangle (rx,ry)-(rx+rw,rx+rh) */
/* Point on the edge are supposed to belong to the rectangle */
extern int in_rect (int x, int y, int rx, int ry, int rw, int rh);
extern int rect_contains (int rx1, int ry1, int rw1, int rh1, int rx2, int ry2, int rw2, int rh2);
extern int rect_overlap (int rx1, int ry1, int rw1, int rh1, int rx2, int ry2, int rw2, int rh2);

extern int distsqr(int x1, int y1, int x2, int y2);

extern int clip_num(int x, int min, int max);
extern int sgn (int x);
extern int is_power_of_two(const int n);

/* Game directory */
extern void get_current_dir(char *dir, int len);
extern void set_game_directory(const char *dir);
extern char *get_game_path(const char *filename);

/* Joystick button held down */
extern int joystick_button(void);
#endif
