#ifndef CTSPARSE_H
#define CTSPARSE_H

#include "tileset.h"

typedef struct CTS_FILE_INFO {
   char *name;
   char *filename;
   char *versionstr;
   int num_tiles;             /* Number of tiles (excl. start) */
   int num_tile_types;        /* Number of tile types          */
   int num_start_tiles;       /* Number of start tiles         */
   int num_start_tile_types;  /* Number of start tile types    */
} CTS_FILE_INFO;

extern void unload_cts_file_info(void);
extern void read_cts_file_info(void);

extern int get_num_cts_files(void);
extern CTS_FILE_INFO *get_cts_info(int num);
extern CTS_FILE_INFO *get_cts_name(const char *name);

extern int load_cts_tileset(char *filename, DEFAULT_TILESET *tileset);
extern int load_cts_startset(char *filename, DEFAULT_TILESET *tileset);

#endif
