#include <allegro.h>
#include <string.h>
#include "assert.h"
#include "tiles.h"
#include "theme.h"
#include "tiletype.h"
#include "mentype.h"
#include "goodtype.h"
#include "team.h"
#include "str.h"
#include "gfx.h"

TEAM *team;

/********************************************/
/*          Code dealing with teams         */
/********************************************/
/* Initialize a team */
void initialize_teams(const int peasants, const int bigmen, const int builders, const int pigs)
{
   int c, n;

   team = malloc(num_teams * sizeof *team);

   /* Carcasonne default game set */
   for(c=0; c<num_teams; c++) {
      for (n=0; n<MENTYPES; n++)
         team[c].men[n] = 0;

      team[c].men[PEASANTS] = peasants;
      team[c].men[BIGMEN] = bigmen;
      team[c].men[MASTERBUILDERS] = builders;
      team[c].men[PIGS] = pigs;

      team[c].colour = makecol(team_colours[c].r, team_colours[c].g, team_colours[c].b);

      for (n=0; n<FEATURE_TYPES; n++)
         team[c].score[n] = 0;

      for (n=0; n<GOODS_TYPES; n++) {
         team[c].goods[n] = 0;
         team[c].score_goods[n] = 0;
      }
   }

   /* Count maximum number of men that can fit on the map */
   n = 0;
   for(c=0; c<num_teams; c++) {
      n += team[c].men[0] + team[c].men[1] + team[c].men[2] + team[c].men[3];
   }
}

void destroy_teams(void)
{
   free(team);
   team = NULL;
   num_teams = 0;
}

int get_partial_team_score(const int team_nr, const int ft)
{
   return team[team_nr].score[ft];
}

int get_team_good_count(const int team_nr, const int ft)
{
   return team[team_nr].goods[ft];
}

int get_team_score(const int nr)
{
   int n, score;
   
   score = 0;
   
   for (n=0; n<FEATURE_TYPES; n++)
      score += team[nr].score[n];

   for (n=0; n<3; n++)
      score += team[nr].score_goods[n];
   return score;
}

int get_team_colour(const int nr)
{
   return team[nr].colour;
}

int get_num_team_names(void)
{
   return num_teams;
}

/* Returns the total number of men still available to a player */
int get_team_men_count(const int t, const int type)
{
   return team[t].men[type];
}

int get_goods_count(const int team_nr, const int type)
{
   return team[team_nr].goods[type];
}

