/**********************************************/
/* .gme file parser                           */
/* Evert Glebbeek 2002, 2003                  */
/* eglebbk@dds.nl                             */
/**********************************************/
#include <allegro.h>
#include <string.h>
#include "global.h"
#include "gmeparse.h"

static PARSER_FUNCTION parser_function[NUM_SECTIONS];

void register_parser_function(PARSER_FUNCTION func, int section)
{
   parser_function[section] = func;
}

static void null_parser(PACKFILE * f)
{
   return;
}

void initialize_gme_parser(void)
{
   int c;

   for (c = 0; c < NUM_SECTIONS; c++)
      parser_function[c] = null_parser;
}

void parse_gme_file(char *filename, int wanted_section)
{
   int section = SECTION_NONE;
   PACKFILE *f;
   char *s = malloc(256);
   char *eol;

   f = pack_fopen(filename, "r");
   if (!f) {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
      allegro_message("Cannot load game description file!\nError reaing %s",
                      filename);
      exit(EXIT_FAILURE);
   }

   while (pack_fgets(s, 256, f)) {
      if (s[0] != ';') {
         /* remove trailing \n */
         eol = strstr(s, "\n");
         if (eol)
            eol[0] = '\0';

         strflushl(s);
         strflushr(s);

         if (s[0]) {            /* skip empty lines */
            if (s[0] == '[') {  /* new section */
               if (!strcmp(s, "[programs]")) {
                  section = PROGRAMS;
               } else if (!strcmp(s, "[commands]")) {
                  section = COMMANDS;
               } else if (!strcmp(s, "[graphics]")) {
                  section = GRAPHICS;
               } else if (!strcmp(s, "[music]")) {
                  section = SOUND;
               } else if (!strcmp(s, "[sample]")) {
                  section = SOUND;
               } else if (!strcmp(s, "[units]")) {
                  section = UNITS;
               } else if (!strcmp(s, "[resources]")) {
                  section = RESOURCES;
               } else {
                  section = SECTION_NONE;
                  popup_message("Invalid section: %s!\n"
                                "Statement ignored", s);
               }
            } else if ((section == wanted_section) ||
                       (wanted_section == ANY_SECTION)) {
               switch (section) {
                  case PROGRAMS:
                     parser_function[section] (f);
                     break;
                  case COMMANDS:
                     /* Read command button data */
                     //load_cmdb_data (f);
                     parser_function[section] (f);
                     break;
                  case GRAPHICS:
                     parser_function[section] (f);
                     break;
                  case SOUND:
                     parser_function[section] (f);
                     break;
                  case UNITS:
                     /* Load next UNIT data */
                     parser_function[section] (f);
                     break;
                  default:
                     TRACE("Warning: statement outside section:\n%s", s);
               }
            }
         }
      }
   }

   free(s);
   pack_fclose(f);
}
