#include <allegro.h>
#include <string.h>
#include "tiles.h"
#include "team.h"
#include "assert.h"
#include "theme.h"
#include "str.h"

/* Return all men from a certain feature to the player */
void remove_men(const int id)
{
   int n, c;
   int x, y;

   /* id=0 is special */
   if (id==0)
      return;

   n = 0;

   for (c=0; c<num_teams; c++) {
      for (n=0; n<MENTYPES; n++) {
         team[c].men[n] += feature_men[id][c].men[n];
         feature_men[id][c].men[n] = 0;
      }
   }

   for (n=0; n<tiles_in_play; n++) {
      for(y=0; y<3; y++) {
         for(x=0; x<3; x++) {
            if (tile[playboard[n]].minitile[y][x].structnum==id) {
               tile[playboard[n]].minitile[y][x].man_team=-1;
               tile[playboard[n]].minitile[y][x].man_type=0;
            }
         }
      }
   }
}

/* Get number of men of a specific type on features of tile id */
int get_tile_feature_men(const int tile_id, const int team, const int man_type)
{
   int x, y;
   int n, count;
   
   count = 0;
   for(y=0; y<3; y++) {
      for(x=0; x<3; x++) {
         n = tile[tile_id].minitile[y][x].structnum;
         count += feature_men[n][team].men[man_type];
      }
   }
   
   return count;
}

/* Return the number of men belonging to one team on a feature */
int get_feature_team_men_count(const int id, const int team)
{
   /* id=0 is special */
   if (id==0)
      return 0;

   return feature_men[id][team].men[PEASANTS] + 2*feature_men[id][team].men[BIGMEN];
}

/* Returns the largest number of men belonging to a single player on a feature */
int get_feature_largest_force(const int id)
{
   int n,c;
   int max = 0;

   for (c=0; c<num_teams; c++) {
      n = get_feature_team_men_count(id, c);
      if (n>max)
         max = n;
   }
   return max;
}

/* Returns the total number of men standing on a feature */
/* id=0 is special - since this function is used to know if we can place */
/*  a man somewhere, we treat this as a special case here and return 1 */
int get_feature_men_count(const int id)
{
   int n,c;

   if (id==0)
      return 1;

   if (id<0)
      return 0;

   n = 0;

   for (c=0; c<num_teams; c++)
      n+=get_feature_team_men_count(id, c);

   return n;
}

