/**********************************************/
/* Palette shifting and manipulation routines */
/* Evert Glebbeek 2003                        */
/* eglebbk@dds.nl                             */
/**********************************************/
#include <allegro.h>
#include "palette.h"

void shift_palette_hue(const PALETTE inpal, PALETTE outpal, const float dh)
{
   int r, g, b;
   float h, s, v;
   int n;
   
   for (n=0; n<256; n++) {
      rgb_to_hsv(inpal[n].r, inpal[n].g, inpal[n].b, &h, &s, &v);
      h += dh;
      s = 0.75;
      while (h>360.0f)
         h-=360.0f;
      while (h<0.0f)
         h+=360.0f;
         hsv_to_rgb(h, s, v, &r, &g, &b);
         outpal[n].r = r;
         outpal[n].g = g;
         outpal[n].b = b;
   }
}

void shift_palette_sat(const PALETTE inpal, PALETTE outpal, const float ds)
{
   int r, g, b;
   float h, s, v;
   int n;
   
   for (n=0; n<256; n++) {
      rgb_to_hsv(inpal[n].r, inpal[n].g, inpal[n].b, &h, &s, &v);
      s += ds;
      while (h>360.0f)
         h-=360.0f;
      while (h<0.0f)
         h+=360.0f;
         hsv_to_rgb(h, s, v, &r, &g, &b);
         outpal[n].r = r;
         outpal[n].g = g;
         outpal[n].b = b;
   }
}

