ifdef CPU
   CFLAGS += -mcpu=$(CPU)
endif

ifdef STATICLINK
   LIBS = `allegro-config --libs --static` -lXrender
   LFLAGS += -static -static-libgcc
else
   ifdef SHAREDLINK
      LIBS = `allegro-config --libs --shared`
   else
      ifdef DEBUGMODE
         LIBS = `allegro-config --libs debug`
      else
         LIBS = `allegro-config --libs`
      endif
   endif
endif

ifndef NONETWORK
   CFLAGS += -Isrc/libnet/include
   LIBS += -lnet
endif

ifdef OSTYPE
   OBJDIR = obj/$(OSTYPE)
   LIBDIR = lib/$(OSTYPE)
   EXEDIR = bin/$(OSTYPE)
   LFLAGS += -Lsrc/libnet/lib/$(OSTYPE)
else
   OBJDIR = obj/unix
   LIBDIR = lib/unix
   EXEDIR = bin/unix
   LFLAGS += -Lsrc/libnet/lib/unix
endif

VERSION=`grep "define GAME_VERSION" Carcassonne/include/carcass.h | sed 's/\#define GAME_VERSION[ ]*\"//'| sed 's/\"//'`
BINARCH = carcassonne-$(VERSION)-bin
SRCARCH = carcassonne-$(VERSION)-src
DATARCH = carcassonne-$(VERSION)-dat

CFLAGS += -pipe
