#ifndef TILETYPE_H
#define TILETYPE_H

/* Tile flags */
#define TILEF_SHIELD    0x0001
#define TILEF_MONASTERY 0x0002
#define TILEF_CATHEDRAL 0x0004
#define TILEF_INN       0x0010
#define TILEF_SIEGE     0x0020

#define TILEF_PORTAL    0x00010000
#define TILEF_VOLCANOE  0x00020000
#define TILEF_DRAGON    0x00040000
#define TILEF_PRINCESS  0x00080000
#define TILEF_FANTASY   (TILEF_PRINCESS|TILEF_DRAGON|TILEF_VOLCANOE|TILEF_PORTAL)

#define TILEF_TRADE1    0x0100
#define TILEF_TRADE2    0x0200
#define TILEF_TRADE3    0x0300
#define TILEF_TRADEANY  0x0300

#define TILEF_BONUS     0x0fff   /* Tile bonuses */

#define TILEF_DBLBEND   0x1000   /* Double bend */
#define TILEF_BRIDGE    0x2000   /* Road bridge */
#define TILEF_CBRIDGE   0x4000   /* City bridge */
#define TILEF_CRBRIDGE  0x8000   /* Mixed City/Road bridge */

#define TILEF_MOD       0xf000   /* Tile modifiers */

/* Identifier to indicate an end of a tile list */
#define NOTILE          -1

/* Feature types */
#define FEATURE_NONE      -1
#define FEATURE_ROAD       0
#define FEATURE_FARM       1
#define FEATURE_MONASTERY  2
#define FEATURE_CITY       3
#define FEATURE_TYPES      4

#endif
