#ifndef TILES_H
#define TILES_H

#include "tiletype.h"
#include "mentype.h"

/* Tile graphics size */
#define TILE_SIZE    48

/* Centre of the map */
#define MAP_CX    128
#define MAP_CY    128

/* Structure holding a mini-tile */
typedef struct MINITILE {
   int connections;
   int conn_dirs[4]; /* Up, left, right, down */
   BITMAP *bmp;
   int transform;
   /* Structure ID - this will identify completed structures in the game */
   int structnum;
   /* Bonus associated with this mini-tile (for roads) */
   int flags;
   /* Man standing on this mini-tile */
   int man_team;
   int man_type;
} MINITILE;

/* Structure for holding map locations */
typedef struct {
   int x, y;
} TILE_LOCATION;

/* Structure holding one large tile */
typedef struct TILE {
   MINITILE minitile[3][3];
   BITMAP *gfx;
   /* Map location this tile is located, or undefined if it is not on the board */
   int x, y;
   int flags;
   int angle;
} TILE;

/* minitile bitmaps - there can be several variants for each bitmap */
typedef struct MINIT_BMP {
   int ngfx;
   int conn_flags;
   int checkerboard_pattern;     /* Checkerboard pattern (odd/even) */
   BITMAP **bmp;
} MINIT_BMP;

typedef struct FEATURE_BONUS {
   int goods[3];
   int shields;
   int cathedrals;
   int inns;
   int siege;
} FEATURE_BONUS;

typedef struct MAP_MEN {
   int men[MENTYPES];
} MAP_MEN;

extern TILE_LOCATION *open_tiles;
extern int *playboard;
extern int num_open_tiles;
extern int tiles_in_play;
extern int tiles_stackp;

extern int num_tiles;
extern TILE *tile;

extern int feature_id_count;
extern int *feature_open;
extern int *feature_type;
extern FEATURE_BONUS *feature_bonus;
extern MAP_MEN **feature_men;

extern BITMAP *emptytile;
extern BITMAP *grid;


/* Centre (x, y) values of mini-tiles in the order u, l, r, d*/
static const int xypairs[4][2] = { {1, 0}, {0, 1}, {2, 1}, {1, 2}};

/* Corners */
static const int xycorners[4][2] = { {0, 0}, {2, 0}, {2, 2}, {0, 2} };

/* Bits connecting cities on the border middle tiles to the outside */
static const int mid_excity_flags[4] = { 0xc0, 0x60, 0x90, 0x30 };

static const int city_mask = 0xf0f0f0f0;
static const int road_mask = 0x0f0f0f0f;
static const int river_mask = 0x00000f00;
static const int city_ur_mask = 0x00000080;
static const int city_ul_mask = 0x00000040;
static const int city_ll_mask = 0x00000020;
static const int city_lr_mask = 0x00000010;

extern void initialize_tileset(void);

extern void initialize_tiles(void);
extern void destroy_tiles(void);

extern void load_tileset(const char *filename);

extern int pop_tile(void);
extern int tiles_remaining(void);

extern void mark_open_tile(int x, int y);
extern void remove_open_tile(int x, int y);

extern int find_tile(int x, int y);

extern void connect_tile(int x, int y);
extern void place_tile(int id, int map_x, int map_y);

extern int tile_fits(const int id, const int x, const int y);
extern int tile_fits_anywhere(const int id);
extern int tile_fits_anywhere_anyway(const int id);

extern int flip_pattern(const int pattern, const int how);

extern void rotate_big_tile_270(int id);
extern void rotate_big_tile_180(int id);
extern void rotate_big_tile_90(int id);

extern BITMAP *get_tile_bitmap(int id);
#endif
