#ifndef TEAM_H
#define TEAM_H

#include "tiletype.h"
#include "mentype.h"
#include "goodtype.h"

/* Default team colours */
static const RGB team_colours[] = {
   { 192,   0,   0, 0 },   // Red
   { 150, 224, 255, 0 },   // Blue
   { 250, 140,  40, 0 },   // Orange
   { 128,   0, 128, 0 },   // Purple
   {   0, 255,   0, 0 },   // Green
   { 192, 192, 192, 0 },   // Grey
   { 255, 180, 255, 0 },   // Pink
   { 255, 255, 255, 0 }    // White
};

typedef struct TEAM {
   int men[MENTYPES];
   int colour;
   int score[FEATURE_TYPES];
   int score_goods[GOODS_TYPES];
   int goods[GOODS_TYPES];
} TEAM;

extern TEAM *team;

extern void initialize_teams(const int peasants, const int bigmen, const int builders, const int pigs);
extern void destroy_teams(void);

extern int get_partial_team_score(const int team_nr, const int ft);
extern int get_team_good_count(const int team_nr, const int ft);
extern int get_team_score(const int team_nr);
extern int get_team_colour(const int team_nr);

extern int get_num_team_names(void);

extern int get_team_men_count(const int team_nr, const int type);
extern int get_goods_count(const int team_nr, const int type);

#endif
