#ifndef RULES_H
#define RULES_H

/* Number of tiles in the game */
//#define NUM_GAME_TILES  256

/* Rule flags */

/* Rule modifiers */
extern int rule_flags;
extern int city_shield_bonus;
extern int base_farm_multi;
extern int bonus_farm_multi;
extern int game_cathedral_multi;
extern int final_cathedral_multi;
extern int game_inn_multi;
extern int final_inn_multi;
extern int tradegood_bonus;

extern void initialize_gameboard(void);

extern void initialize_teams(const int peasants, const int bigmen, const int builders, const int pigs);
extern void destroy_teams(void);

extern int get_partial_team_score(const int team_nr, const int ft);
extern int get_team_good_count(const int team_nr, const int ft);
extern int get_team_score(const int team);
extern int get_team_colour(const int team);
extern int get_num_team_names(void);
extern const char *get_team_names(const int c);

extern int get_tile_feature_men(const int tile_id, const int team, const int man_type);
extern int get_team_men_count(const int team, const int type);
extern void place_man(const int tx, const int ty, const int mtx, const int mty, const int team, const int type);

extern int get_goods_count(const int team_nr, const int type);

extern void score_tile(int x, int y, int trader);
extern void end_score(void);

extern int can_place_flag(int tile_x, int tile_y, int mx, int my, int team, int type);

extern void draw_flags(BITMAP *dest, int dest_x, int dest_y, int tx, int ty, int team, int type);
extern int count_number_flags(int tx, int ty);
extern void draw_tilemap(BITMAP *dest, int float_tile, int dest_x, int dest_y, int tx, int ty, int w, int h);
#endif
