#ifndef PLAYGAME_H
#define PLAYGAME_H

extern volatile unsigned int global_cycles_passed;

extern void playgame_init(const int gamespeed);
extern void playgame(void);

/* Interface routines for notifying the game loop that the state has changed */
extern void set_game_done(void);
extern void set_screen_changed(void);

/* Timer synchronization and reset routines */
extern void synchronize(void);
extern void reset_game_timer(void);

/* These routines should be provided by the user */
extern void playgame_preamble(void);        // Called at start of playgame()
extern void playgame_closing(void);         // Called at end of playgame()
extern void game_gfx_update_preamble(void); // Called before gfx update
extern void game_gfx_update(void);          // Called to do gfx update
extern void game_gfx_skip(void);            // Called when gfx update not needed
extern void game_state_update(void);        // Called to update game state
extern void game_input(void);               // Process user input

#endif
