#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "ctsparse.h"
#include "tileset.h"

DEFAULT_TILESET *game_tileset = NULL;
DEFAULT_TILESET *start_tiles = NULL;
int num_tile_types = 0;
int num_start_tiles = 0;
int num_start_tile_types = 0;

/* The default tileset */
static DEFAULT_TILESET default_tileset[] = {
   /* The base game */
   { 3, 0xc0, 0x0a, 0x0a, 0x00, 0x0000},  /* Three in the pile, one as start */
   { 3, 0xc0, 0x0a, 0x0a, 0x05, 0x0000},
   { 3, 0x00, 0x60, 0x90, 0x00, 0x0000},
   { 2, 0xc0, 0x00, 0x90, 0x00, 0x0000},
   { 5, 0xc0, 0x00, 0x00, 0x00, 0x0000},

   { 3, 0xc0, 0x0a, 0x00, 0x05, 0x0000},
   { 3, 0xc0, 0x00, 0x0a, 0x05, 0x0000},
   { 2, 0x00, 0xf0, 0xf0, 0x00, 0x0001},
   { 1, 0x00, 0xf0, 0xf0, 0x00, 0x0000},
   { 9, 0x00, 0x0a, 0x00, 0x05, 0x0000},

   { 2, 0xe0, 0xe0, 0x0a, 0x05, 0x0001},  /* Corner city - 0f/0f also works */
   { 3, 0xe0, 0xe0, 0x0a, 0x05, 0x0000},
   { 2, 0xf0, 0xf0, 0x00, 0x00, 0x0001},
   { 3, 0xf0, 0xf0, 0x00, 0x00, 0x0000},
   { 8, 0x05, 0x00, 0x00, 0x05, 0x0000},

   { 2, 0xf0, 0xf0, 0xf0, 0x05, 0x0001},
   { 1, 0xf0, 0xf0, 0xf0, 0x05, 0x0000},
   { 1, 0xf0, 0xf0, 0xf0, 0x00, 0x0001},
   { 3, 0xf0, 0xf0, 0xf0, 0x00, 0x0000},
   { 4, 0x00, 0x0a, 0x0a, 0x05, 0x0000},

   { 2, 0x00, 0x00, 0x00, 0x05, 0x0002},
   { 4, 0x00, 0x00, 0x00, 0x00, 0x0002},
   { 1, 0xf0, 0xf0, 0xf0, 0xf0, 0x0001},
   { 1, 0x05, 0x0a, 0x0a, 0x05, 0x0000},

//   { 0, 0x00, 0x00, 0x00, 0x00, 0x0000},
   /* Expansions */

   /* Inns and Cathedrals (complete) */
   { 1, 0x00, 0x0a, 0x0a, 0x00, 0x0002},     /* Monastery with double road */
   { 2, 0xf0, 0xf0, 0xf0, 0xf0, 0x0004},     /* Cathedrals */
   { 1, 0xc0, 0x60, 0x90, 0x30, 0x0000},
   { 1, 0xc0, 0x60, 0x90, 0x00, 0x0000},
   { 1, 0xc1, 0x0a, 0x0a, 0x34, 0x0000},

   { 1, 0xe0, 0xe0, 0x90, 0x00, 0x0001},
   { 1, 0xf0, 0x00, 0x40, 0x80, 0x0000},     /* Pointed city */
   { 1, 0xc1, 0x00, 0x00, 0x05, 0x0000},
   { 1, 0xf0, 0xf0, 0x00, 0x05, 0x0000},
   { 1, 0x34, 0xf0, 0xf0, 0xc1, 0x0001},

   { 1, 0x05, 0x00, 0xf0, 0xf0, 0x0010},
   { 1, 0x05, 0x0a, 0x90, 0x00, 0x0010},
   { 1, 0x05, 0x0a, 0xb0, 0xb0, 0x0011},
   { 1, 0x05, 0x00, 0x0a, 0x05, 0x0010},     /* Crossing with inn */
   { 1, 0x05, 0x00, 0x00, 0x05, 0x0010},     /* Straight road with inn */
   
   { 1, 0x05, 0x0a, 0x00, 0x00, 0x0010},     /* Curved road with inn */
   { 1, 0x05, 0x0a, 0x0a, 0x05, 0x1000},     /* Double bend */

   /* Traders and builders */
   { 1, 0x00, 0x0a, 0x0a, 0x05, 0x0002},     /* Monastery with crossing */
   { 1, 0xc1, 0x00, 0x0a, 0x00, 0x0000},
   { 1, 0xc1, 0x0a, 0x00, 0x05, 0x0000},
   { 1, 0x05, 0x0a, 0x0a, 0x05, 0x2000},

   /* These don't work properly yet... */
//   { 1, 0xe0, 0xe0, 0xb0, 0xb0, 0x0000},
//   { 1, 0xd1, 0x0a, 0xd2, 0x05, 0x1000},

   /* King and Scout */
   { 1, 0xc0, 0x00, 0x00, 0x00, 0x0002},
   { 1, 0xf0, 0xf0, 0x68, 0xc1, 0x0000},
   { 1, 0xc1, 0x0a, 0x00, 0x00, 0x0000},
   { 1, 0xc1, 0x0a, 0x0a, 0x05, 0x1000},
   { 1, 0xf0, 0xf0, 0xf0, 0xf0, 0x4000},

   /* End of data */
   { 0, 0x00, 0x00, 0x00, 0x00, 0x0000}
};

/* Default start tile */
static DEFAULT_TILESET default_start_tile[] = {
   { 1, 0xc0, 0x0a, 0x0a, 0x00, 0x0000},

   /* End of data */
   { 0, 0x00, 0x00, 0x00, 0x00, 0x0000}
};

/* Alternate start set: the River */



/* Load set of tile definitions. Pass NULL for the default build-in Carcassone tileset */
void load_tileset(const char *name)
{
   CTS_FILE_INFO *cts;
   int old_size;
   
   if (!name) {
      num_tile_types = sizeof default_tileset / sizeof *default_tileset-1;

      game_tileset = realloc(game_tileset, num_tile_types * sizeof *game_tileset);
      
      memcpy(game_tileset, default_tileset, num_tile_types * sizeof *game_tileset);
      
      return;
   }
   
   cts = get_cts_name(name);
   if (cts) {
      old_size = num_tile_types;
      num_tile_types += cts->num_tile_types;
      game_tileset = realloc(game_tileset, num_tile_types * sizeof *game_tileset);
      load_cts_tileset(cts->filename, game_tileset + old_size);
   }
}

void load_starttile(const char *name)
{
   CTS_FILE_INFO *cts;
   int old_size;
   
   if (!name) {
      num_start_tiles = sizeof default_start_tile / sizeof *default_start_tile-1;
      num_start_tile_types = num_start_tiles;
      
      start_tiles = realloc(start_tiles, num_start_tiles * sizeof *start_tiles);
      
      memcpy(start_tiles, default_start_tile, num_start_tiles * sizeof *start_tiles);
      return;
   }
   
   cts = get_cts_name(name);
   if (cts) {
      old_size = num_start_tiles;
      num_start_tiles += cts->num_start_tiles;
      num_start_tile_types += cts->num_start_tile_types;
      start_tiles = realloc(start_tiles, num_start_tiles * sizeof *start_tiles);
      load_cts_startset(cts->filename, start_tiles + old_size);
   }
}

void unload_tileset(void)
{
   free(game_tileset);
   free(start_tiles);

   game_tileset = NULL;
   start_tiles = NULL;

   num_tile_types = 0;
   num_start_tiles = 0;
   num_start_tile_types = 0;
}
