#include <allegro.h>
#include <string.h>
#include "theme.h"
#include "assert.h"
#include "global.h"
#include "str.h"
#include "gfx.h"

static DATAFILE *theme_dat = NULL;
static DATAFILE *flags_dat = NULL;
static DATAFILE *goods_dat = NULL;
static DATAFILE *attrib_dat = NULL;
static DATAFILE *shadows_dat = NULL;
static DATAFILE *men_dat = NULL;
static DATAFILE *mapui_dat = NULL;
static DATAFILE *tilegfx_dat = NULL;
DATAFILE *odd_tilegfx_dat = NULL;
DATAFILE *even_tilegfx_dat = NULL;
DATAFILE *common_tilegfx_dat = NULL;
static DATAFILE *bonus_dat = NULL;
int num_teams = 0;

int theme_loaded(void)
{
   return theme_dat != NULL;
}

/* Load graphics theme */
void load_theme(const char *filename)
{
   /* Load datafiles */
   theme_dat = load_datafile(get_game_path(filename));
   if (!theme_dat) {
      set_gfx_mode(GFX_TEXT, 0,0, 0,0);
      allegro_message("Error loading theme %s!\n", filename);
      exit(EXIT_FAILURE);
   }

   flags_dat = find_datafile_object(theme_dat, "Flags");
   goods_dat = find_datafile_object(theme_dat, "Goods");
   attrib_dat = find_datafile_object(theme_dat, "MenAttributes");
   shadows_dat = find_datafile_object(theme_dat, "MenShadow");
   men_dat = find_datafile_object(theme_dat, "Men");
   mapui_dat = find_datafile_object(theme_dat, "MapUI");
   tilegfx_dat = find_datafile_object(theme_dat, "Tiles");


   if (!flags_dat || !goods_dat || !attrib_dat || !shadows_dat || !men_dat || !mapui_dat || !tilegfx_dat) {
      set_gfx_mode(GFX_TEXT, 0,0, 0,0);
      allegro_message("Error loading theme %s!\n", filename);
      exit(EXIT_FAILURE);
   }
   flags_dat = flags_dat->dat;
   goods_dat = goods_dat->dat;
   attrib_dat = attrib_dat->dat;
   shadows_dat = shadows_dat->dat;
   men_dat = men_dat->dat;
   mapui_dat = mapui_dat->dat;
   tilegfx_dat = tilegfx_dat->dat;

   odd_tilegfx_dat = find_datafile_object(tilegfx_dat, "Odd");
   even_tilegfx_dat = find_datafile_object(tilegfx_dat, "Even");
   common_tilegfx_dat = find_datafile_object(tilegfx_dat, "Common");
   bonus_dat = find_datafile_object(tilegfx_dat, "Bonus");

   if (!odd_tilegfx_dat || !even_tilegfx_dat || !common_tilegfx_dat || !bonus_dat) {
      set_gfx_mode(GFX_TEXT, 0,0, 0,0);
      allegro_message("Error loading theme %s!\n", filename);
      exit(EXIT_FAILURE);
   }

   odd_tilegfx_dat = odd_tilegfx_dat->dat;
   even_tilegfx_dat = even_tilegfx_dat->dat;
   common_tilegfx_dat = common_tilegfx_dat->dat;
   bonus_dat = bonus_dat->dat;

   /* Count number of teams defined in this theme */
   for (num_teams = 0; men_dat[num_teams].type != DAT_END; num_teams++);
}

void unload_theme(void)
{
   /* Unload datafiles */
   unload_datafile(theme_dat);
   theme_dat = NULL;

   flags_dat = NULL;
   goods_dat = NULL;
   attrib_dat = NULL;
   shadows_dat = NULL;
   men_dat = NULL;
   mapui_dat = NULL;
   tilegfx_dat = NULL;
   odd_tilegfx_dat = NULL;
   even_tilegfx_dat = NULL;
   common_tilegfx_dat = NULL;
   bonus_dat = NULL;
   
   num_teams = 0;
}

BITMAP *get_flag_bitmap(const int type)
{
   return flags_dat[type].dat;
}

BITMAP *get_goods_bitmap(const int type)
{
   return goods_dat[type].dat;
}

RLE_SPRITE *get_feature_man_attribute(int feature_type)
{
   return attrib_dat[2+feature_type].dat;
}

RLE_SPRITE *get_team_man_sprite(const int team, const int type)
{
   DATAFILE *df;

   df = men_dat[team].dat;
   return df[type].dat;
}

RLE_SPRITE *get_man_shadow_sprite(const int type)
{
   return shadows_dat[type].dat;
}

RLE_SPRITE *get_man_attrib_sprite(const int type)
{
   return attrib_dat[type].dat;
}

BITMAP *get_theme_gfx(int class, char *name)
{
   DATAFILE *df = NULL;
   
   switch (class) {
      case THEME_BONUS_GFX:
         df = bonus_dat;
         break;
      case THEME_UI_GFX:
         df = mapui_dat;
         break;
      default:
         return NULL;
   }
   
   df = find_datafile_object(df, name);
   return df?df->dat:NULL;
}

const char *get_team_names(const int c)
{
   /* Skip first character that is only used for ordering in the datafile */
   return get_datafile_property(men_dat + c, DAT_ID('N', 'A', 'M', 'E'))+1;
}

