#ifndef THEME_H
#define THEME_H

#define THEME_BONUS_GFX    1
#define THEME_GOODS_GFX    2
#define THEME_UI_GFX       3

extern DATAFILE *odd_tilegfx_dat;
extern DATAFILE *even_tilegfx_dat;
extern DATAFILE *common_tilegfx_dat;

extern int num_teams;

extern int theme_loaded(void);
extern void load_theme(const char *filename);
extern void unload_theme(void);

extern BITMAP *get_theme_gfx(int class, char *name);
extern BITMAP *get_goods_bitmap(const int type);
extern BITMAP *get_flag_bitmap(const int type);
extern RLE_SPRITE *get_feature_man_attribute(int feature_type);
extern RLE_SPRITE *get_team_man_sprite(const int team, const int type);
extern RLE_SPRITE *get_man_shadow_sprite(const int type);
extern RLE_SPRITE *get_man_attrib_sprite(const int type);

extern const char *get_team_names(const int c);

#endif
