#ifndef ASSERT_H
#define ASSERT_H

#include <stdlib.h>
#include <stdio.h>

#ifdef DEBUGMODE
#define assert(x) {if(!(x)){fprintf(stderr, "assert() failed in line %d of %s!\n", __LINE__, __FILE__); abort();}}
#define trace(s) {fprintf(stderr, "%s in %s, line %d of %s!\n", s, __FUNCTION__, __LINE__, __FILE__);}
#else
#define assert(x) {}
#define trace(x) {}
#endif

#endif
