/*objects.h*/


#define RESOL_X 800
#define RESOL_Y 600

#define MUST_COMPUTE_SPEED 1
#define SPACE_PRESSED 2
#define FILLING_BUCKET 4
#define DUMPING_NUTELLA 8
#define HAS_EATED_NUTELLA 16

typedef struct{
        unsigned int x,y;
}point;
        
typedef struct {
        point pos;
        char radius;
        short int ttl;
}circle_t;

typedef struct { /*what is a player */
        point refpt; /*position*/
        unsigned short int xsize;
        unsigned short int ysize;
        short int energy;
        int state; /*bitfield for various information*/
        float add_x, add_y; /*non integer coordinates*/
        float speed;
        float max_speed;
        int ttl_in_nutella; /*"air"*/
        int stomach_left; /*how much he can eat*/
        BITMAP * sprite;
}liveplayer;

typedef struct { /*our troll*/
        int state;
        int time_to_pack;
        int sprtime;
        BITMAP * spr;
        BITMAP * normal;
        BITMAP * happy;
        BITMAP * eating;
}livetroll;
        
        
typedef struct { /*a "stock" of nutella*/
        point refpt; /*its top left position on the screen*/
        int amount; /*how much nutella is there in it*/
        unsigned short int xsize;
        float sine; /*sine wave variation*/
        circle_t circles[30]; /*the "asperities"*/
}stock_t;

typedef struct { /*the player's bucket*/
        int capacity; /*total capacity*/
        int content; /*how much it contains*/
        int time_to_next; /*time left before next flood diminution*/
}bucket_t;

typedef struct {
        point refpt;
        int ttl;
        char active;
        BITMAP * sprite;
        BITMAP * message;
}dumping_point;

typedef struct {
        point refpt;
        short int size;
        short int angle; /*in degrees*/
        int delay_to_bullet; /*delay before firing the next bullet*/
        BITMAP * sprite;
}nutellator_t;

typedef struct {
        point refpt;
        int ttl;
}target_t;

typedef struct {
        point refpt;
        float add_x, add_y;
        short int size;
        short int offset;
        short int angle;
        BITMAP * temp;
        char exists;
}bullet_t;

int score;
/*int ncolor;*/
char use_cannon; /*0 if the cannon has not been unlocked*/
char game_ended; /*1 if the game has ended*/
int nutella_flow_spd;
int nutella_flow_delay;

liveplayer * perso;
livetroll * troll;
stock_t * flooding_nutella;
stock_t * troll_nutella;
bucket_t * bucket;
dumping_point * dump;
dumping_point * dump2;
nutellator_t * cannon;
target_t * target;
bullet_t * wave;

BITMAP * bg;
BITMAP * vscreen; /*the virtual screen for double buffering*/
