#include "all_inc.h"

/*timer related variables*/
int game_spd_counter = 1;
int fps_counter = 0;
int last_fps = 1;
int avg_fps = 20;
int nb_fps_cycles = 0;
int cyclecount = 0;


void increment_game_spd_counter()
{
        game_spd_counter++;
}
END_OF_FUNCTION(increment_game_spd_counter)

void fps_timer()
{
        last_fps=fps_counter;
        fps_counter=0;
        nb_fps_cycles++;
        avg_fps=((nb_fps_cycles-1)*avg_fps+last_fps)/nb_fps_cycles;
}
END_OF_FUNCTION(fps_timer)

int main()
{
        
/*set_uformat(U_ASCII);*/
allegro_init();
install_keyboard();
install_timer();

set_color_depth(8);
request_refresh_rate(85);


if( set_gfx_mode(GFX_AUTODETECT_WINDOWED, RESOL_X, RESOL_Y, 0, 0) != 0)
   	{
   	fprintf(stderr,"set_gfx_mode() failed, using another driver.");
        if( set_gfx_mode(GFX_AUTODETECT, RESOL_X, RESOL_Y, 0, 0) != 0)
                {
                if (set_gfx_mode(GFX_SAFE, RESOL_X, RESOL_Y, 0, 0) != 0) 
                        {
                        set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
                        allegro_message("Error setting graphics mode\n%s\n", allegro_error);
                        return 1;
                        }
                }
   	}

/*now we can initialise the screen*/
vscreen = create_bitmap(RESOL_X,RESOL_Y);
clear_bitmap(vscreen);
/*ready for the game*/
printf("Calling game()\n");
game();

/*clean up the mess*/
free_memory();
destroy_bitmap(vscreen);
set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
allegro_exit();
return 0;
}
END_OF_MAIN()


int allocate_memory()
{ /*allocate memory to the structures*/
perso = (liveplayer *)calloc(1, sizeof(liveplayer));
troll = (livetroll *)calloc(1, sizeof(livetroll));
flooding_nutella = (stock_t *)calloc(1, sizeof(stock_t));
troll_nutella = (stock_t *)calloc(1, sizeof(stock_t));
bucket = (bucket_t *)calloc(1, sizeof(bucket_t));
dump = (dumping_point *)calloc(1, sizeof(dumping_point));
dump2 = (dumping_point *)calloc(1, sizeof(dumping_point));
cannon = (nutellator_t *)calloc(1, sizeof(nutellator_t));
target = (target_t *)calloc(1, sizeof(target_t));
wave = (bullet_t *)calloc(1, sizeof(bullet_t));
return 0;
}

int free_memory()
{
destroy_bitmap(perso->sprite);
free(perso);
destroy_bitmap(troll->normal);
destroy_bitmap(troll->happy);
destroy_bitmap(troll->eating);
free(troll);
free(flooding_nutella);
free(troll_nutella);
free(bucket);
destroy_bitmap(dump->sprite);
destroy_bitmap(dump->message);
destroy_bitmap(bg);
free(dump);
destroy_bitmap(dump2->sprite);
free(dump2);
destroy_bitmap(cannon->sprite);
free(cannon);
free(target);
destroy_bitmap(wave->temp);
free(wave);
return 0;
}


void game()
{
/*first, allocate memory, then fill in the structures, then set up the timers and go for the loop*/
allocate_memory();
fill_data();

LOCK_VARIABLE(speed_counter);
LOCK_FUNCTION(increment_game_spd_counter);
LOCK_FUNCTION(fps_timer);
LOCK_VARIABLE(game_spd_counter);
LOCK_VARIABLE(last_fps);
LOCK_VARIABLE(fps_counter);
LOCK_VARIABLE(nb_fps_cycles);
LOCK_VARIABLE(avg_fps);

install_int_ex(increment_game_spd_counter, BPS_TO_TIMER(50));
install_int_ex(fps_timer,SECS_TO_TIMER(1));

int end_get_touche = 0;

while(!end_get_touche){
        while(game_spd_counter > 0)
                {
                end_get_touche=main_loop();
                if(end_get_touche)
                        break;
                cyclecount++;
                display_all();
                fps_counter++;
                game_spd_counter--;
                }
        rest(0);
}

remove_int(increment_game_spd_counter);
remove_int(fps_timer);
printf("Bringing gameover screen.\n");
if(end_get_touche == 5)
        defeat_screen();
else
        leave_screen();
}

