#include "all_inc.h"

extern int last_fps, cyclecount, nb_fps_cycles;

int display_all()
{

        
acquire_bitmap(vscreen);
clear_bitmap(vscreen);
for(int i = 0; i < 10; i++)
        for(int y = 0; y < 10; y++)
                blit(bg, vscreen, 0, 0, 65*i, 45*y, 65, 45);

display_gamescreen();
display_troll();
display_troll_feed();
display_statistics();

/*textprintf_ex(vscreen, font, 610, 13, 255, -1, "Driver %s",gfx_driver->name);
textprintf_ex(vscreen, font, 610, 28, 255, -1, "FPS : %i",last_fps);
textprintf_ex(vscreen, font, 610, 43, 255, -1, "GameTime : %i ; %i ", cyclecount, nb_fps_cycles);*/


release_bitmap(vscreen);
vsync();
acquire_screen();
blit(vscreen, screen, 0, 0, 0, 0, RESOL_X, RESOL_Y);
release_screen();

return 0;
}



int display_gamescreen()
{
rect(vscreen, 0, 0, 650, 450, 0);

/*display the flooding nutella*/
rectfill(vscreen, flooding_nutella->refpt.x, flooding_nutella->refpt.y, flooding_nutella->refpt.x + flooding_nutella->xsize, flooding_nutella->refpt.y + flooding_nutella->amount - 10, 210);
for(int i = 0; i < flooding_nutella->xsize; i++)
        { /*display the sine wave : base y varies from -5 to 5 due to sinus*/
        double angle_i = 3.141592653589793238462643383279502 * i / 180; /*the angle in rad*/
        double add_angle = 3.141592653589793238462643383279502 * cyclecount / 180;
        double angle = angle_i + add_angle;
        unsigned int sine_point = flooding_nutella->refpt.y + flooding_nutella->amount + (int)(10 * sin(angle));
        if(sine_point > flooding_nutella->refpt.y)
                putpixel(vscreen, flooding_nutella->refpt.x + i, sine_point, 137);
        if((i % 400) < 150)
                {
                if(sine_point - 30 > flooding_nutella->refpt.y)
                        {
                        putpixel(vscreen, flooding_nutella->refpt.x - 1 + i, sine_point - 30, 184);
                        putpixel(vscreen, flooding_nutella->refpt.x - 1 + i, sine_point - 29, 185);
                        }
                }
        if((i % 300) < 175 && (i % 400) > 25 && (sine_point - 150) > flooding_nutella->refpt.y )
                {
                putpixel(vscreen, flooding_nutella->refpt.x - 1 + i, sine_point - 150, 184);
                putpixel(vscreen, flooding_nutella->refpt.x - 1 + i, sine_point - 149, 185);
                }
        for(unsigned int y = 1; sine_point - y >= flooding_nutella->refpt.y + flooding_nutella->amount - 10 ; y++)
                putpixel(vscreen, flooding_nutella->refpt.x + i, sine_point - y, 210);
        }
        
for(int i = 0; i < 30; i ++)
        { /*display circles*/
        if(flooding_nutella->circles[i].ttl && (flooding_nutella->amount - flooding_nutella->circles[i].pos.y > 10))
                { /*then it exists*/
                circle(vscreen, flooding_nutella->circles[i].pos.x , flooding_nutella->amount - flooding_nutella->circles[i].pos.y, flooding_nutella->circles[i].radius, 137);
                }
        }

/*display the player*/
masked_blit(perso->sprite, vscreen, 0, 0,  perso->refpt.x, perso->refpt.y, 60, 101);

/*display the dump*/
if(dump->active)
        masked_blit(dump->sprite, vscreen, 0, 0,  dump->refpt.x, dump->refpt.y, 143, 94);
else
        masked_blit(dump2->sprite, vscreen, 0, 0,  dump2->refpt.x, dump2->refpt.y, 143, 94);

/*display the message "do not feed the troll"*/
if(is_player_near_dump())
        masked_blit(dump->message, vscreen, 0, 0, 5, 530, 300, 70);

if(use_cannon)
        {
        /*display the cannon*/
        line(vscreen, cannon->refpt.x, cannon->refpt.y, cannon->refpt.x + cannon->size * cos(3.14159 * cannon->angle / 180),\
                                cannon->refpt.y - cannon->size * sin(3.14159 * cannon->angle / 180), 5);
        pivot_sprite(vscreen, cannon->sprite, cannon->refpt.x, cannon->refpt.y, 20, 70, ftofix(- 256 * (cannon->angle - 90) / 360));
        /*display the target*/
        circlefill(vscreen, target->refpt.x, target->refpt.y, 20, 184);
        circlefill(vscreen, target->refpt.x, target->refpt.y, 15, 137);
        circlefill(vscreen, target->refpt.x, target->refpt.y, 10, 185);
        circlefill(vscreen, target->refpt.x, target->refpt.y, 5, 138);
        circlefill(vscreen, target->refpt.x, target->refpt.y, 2, 184);
        
        /*display the wave (if relevant)*/
        display_wave();
        }
return 0;
}

int display_statistics()
{

/*player energy*/        
textout_ex(vscreen, font, "Energy", 125, 470, 255, -1);
rect(vscreen, 200, 470, 300, 481, 4);
rectfill(vscreen, 200, 471, 200 + perso->energy / 10, 480, 4);
textout_ex(vscreen, font, "Air", 125, 485, 255, -1);
rect(vscreen, 200, 485, 300, 496, 1);
rectfill(vscreen, 200, 486, 200 + perso->ttl_in_nutella / 3, 495, 76);
textout_ex(vscreen, font, "Stomach", 125, 500, 255, -1);
rect(vscreen, 200, 500, 300, 511, 183);
rectfill(vscreen, 200, 501, 200 + (100 - 2*perso->stomach_left), 511, 137);
textprintf_ex(vscreen, font, 25, 480, 255, -1, "Score %i ", score);

if(use_cannon)
        {
        textout_ex(vscreen, font, "Nutellator", 15, 515, 255, -1);
        rect(vscreen, 100, 515, 200, 526, 4);
        int color = 2 /*+ (cannon->delay_to_bullet / 3) % 33*/;
        rectfill(vscreen, 100, 516, 100 + 100 - (cannon->delay_to_bullet / 3), 525, color);
        }
textprintf_centre_ex(vscreen, font, 400, 575, 255, -1, "%i / %i", bucket->content, bucket->capacity);
/*Speed - THE CENTRAL THING IN THAT GAME*/
textprintf_centre_ex(vscreen, font, 560, 575, 255, -1, "%04f", perso->speed);

/*bucket filling*/
textout_ex(vscreen, font, "Bucket", 330, 450 + 10, 255, -1);
rect(vscreen, 360, 450 + 20, 440, 570, 2);
rectfill(vscreen, 361, 570, 439, 570 - 100*((float)bucket->content / (float)bucket->capacity), 190);

/*speed - graphical representation*/
textout_ex(vscreen, font, "Speed", 490, 450 + 10, 255, -1);
rect(vscreen, 520, 450 + 20, 600, 570, 2);
rectfill(vscreen, 521, 570, 599, 570 - 6.66666*perso->speed, 4);

return 0;
}


int display_troll()
{
masked_blit(troll->spr, vscreen, 0, 0,  655, 455, 150, 150);
return 0;
}

int display_troll_feed()
{
rect(vscreen, troll_nutella->refpt.x - 1, 5, troll_nutella->refpt.x + troll_nutella->xsize + 1, troll_nutella->refpt.y + troll_nutella->amount, 137);


/*display the troll nutella*/
rectfill(vscreen, troll_nutella->refpt.x, troll_nutella->refpt.y + 10, troll_nutella->refpt.x + troll_nutella->xsize - 1, troll_nutella->refpt.y + troll_nutella->amount, 210);
for(int i = 0; i < troll_nutella->xsize; i++)
        { /*display the sine wave : base y varies from -5 to 5 due to sinus*/
        double angle_i = 3.141592653589793238462643383279502 * i / 180; /*the angle in rad*/
        double add_angle = 3.141592653589793238462643383279502 * cyclecount / 180;
        double angle = angle_i + add_angle;
        unsigned int sine_point = troll_nutella->refpt.y + (int)(10 * sin(angle));
        putpixel(vscreen, troll_nutella->refpt.x + i, sine_point, 137);
        if((i % 400) < 150 &&(troll_nutella->amount > 40))
                {
                putpixel(vscreen, troll_nutella->refpt.x - 1 + i, sine_point + 30, 184);
                putpixel(vscreen, troll_nutella->refpt.x - 1 + i, sine_point + 29, 185);
                }
        if((i % 300) < 175 && (i % 400) > 25 && (troll_nutella->amount > 160))
                {
                putpixel(vscreen, troll_nutella->refpt.x - 1 + i, sine_point + 150, 184);
                putpixel(vscreen, troll_nutella->refpt.x - 1 + i, sine_point + 149, 185);
                }
        for(unsigned int y = 1; y <= - sine_point + troll_nutella->refpt.y + 10 ; y++)
                putpixel(vscreen, troll_nutella->refpt.x + i, sine_point + y, 210);
        }
        
for(int i = 0; i < 10; i ++)
        { /*display circles*/
        if(troll_nutella->circles[i].ttl && (troll_nutella->refpt.y + troll_nutella->circles[i].pos.y) < 445)
                { /*then it exists*/
                circle(vscreen, troll_nutella->circles[i].pos.x, troll_nutella->refpt.y + troll_nutella->circles[i].pos.y, troll_nutella->circles[i].radius, 137);
                }
        }
        
line(vscreen, 690, 50, 800, 50, 255);
textout_ex(vscreen, font, "Score", 660, 30, 255, -1);
textout_ex(vscreen, font, "+ 1000", 660, 40, 255, -1);
return 0;
}


int display_wave()
{
/*we draw the un rotated wave on temp, then rotate it using pivot_sprite()*/
if(wave->exists)
        {
        clear_bitmap(wave->temp);
        for(int i = 0; i < wave->size; i ++)
                putpixel(wave->temp, i, 5 + 5*sin(3.14159 * (10* i + wave->offset) / 180), 4);
        /*blit(wave->temp, vscreen, 0, 0, 550, 430, wave->size, 10);
        putpixel(vscreen, wave->refpt.x, wave->refpt.y, 4);*/
        pivot_sprite(vscreen, wave->temp, wave->refpt.x, wave->refpt.y, 0, 5 + 5*sin(3.14159 * wave->offset) / 180, ftofix(- 256 * wave->angle / 360));
        }

return 0;
}

int leave_screen()
{
clear_keybuf();
clear_bitmap(screen);
textout_centre_ex(screen, font, "Game over", RESOL_X / 2, RESOL_Y /3, 255, -1);
textprintf_ex(screen, font, RESOL_X / 4, RESOL_Y / 2, 255, -1, "Left game after %i seconds. You made %i points.", nb_fps_cycles, score);
rest(5000);
while(!keypressed())
        rest(1);
return 0;
}

int defeat_screen()
{
clear_keybuf();
clear_bitmap(screen);
textout_centre_ex(screen, font, "Game over", RESOL_X / 2, RESOL_Y /3, 255, -1);
textprintf_centre_ex(screen, font, RESOL_X / 2, RESOL_Y / 2, 255, -1, "You were defeated by that damn Nutella factory after %i seconds, with a score of %i.", nb_fps_cycles, score);
rest(5000);
while(!keypressed())
        rest(1);
return 0;
}

int cannon_splash()
{
remove_int(increment_game_spd_counter);
remove_int(fps_timer);

clear_keybuf();

rectfill(screen, 130, 100, 670, 500, 0);
rect(screen, 130, 100, 670, 500, 255);
textout_centre_ex(screen, font, "Nutellator Unlocked", RESOL_X / 2, RESOL_Y /3, 4, -1);
/*void textout_justify_ex(BITMAP *bmp, const FONT *f, const char *s, int x1, x2, y, diff, color, bg);*/
textout_justify_ex(screen, font, "The Nutellator is a powerful cannon. Thanks to your performance,", 140, 490, RESOL_Y / 2 - 10, 50, 255, -1);
textprintf_centre_ex(screen, font, RESOL_X / 2, RESOL_Y / 2, 255, -1, "you were granted one by your boss.");
textout_justify_ex(screen, font, "Use left control and left alt to aim and left shift to fire.", 140, 490, RESOL_Y / 2 + 30, 50, 255, -1);
textout_justify_ex(screen, font, "Hitting the target will microwave the unstable Nutella,", 140, 490, RESOL_Y / 2 + 40, 50, 255, -1);
textout_justify_ex(screen, font, "which will greatly help you.", 140, 490, RESOL_Y / 2 + 50, 50, 255, -1);
textout_justify_ex(screen, font, "The wave itself slows the Nutella down.", 140, 190, RESOL_Y / 2 + 60, 50, 255, -1);

textprintf_ex(screen, font, RESOL_X / 3, RESOL_Y / 2 + 100, 255, -1, "Press ENTER.");
while(! key[KEY_ENTER])
        rest(15);
install_int_ex(increment_game_spd_counter, BPS_TO_TIMER(50));
install_int_ex(fps_timer,SECS_TO_TIMER(1));
return 0;
}

int victory_screen()
{
remove_int(increment_game_spd_counter);
remove_int(fps_timer);

clear_keybuf();

rectfill(screen, 130, 100, 670, 500, 0);
rect(screen, 130, 100, 670, 500, 255);
textout_centre_ex(screen, font, "You won !", RESOL_X / 2, RESOL_Y /3, 255, -1);
textprintf_centre_ex(screen, font, RESOL_X / 2, RESOL_Y / 2 - 10, 255, -1, "You reached 32000 points !");
textprintf_centre_ex(screen, font, RESOL_X / 2, RESOL_Y / 2, 255, -1, "Your mission has ended and the troll will be freed soon.");
textprintf_centre_ex(screen, font, RESOL_X / 2, RESOL_Y / 2 + 30, 255, -1, "Press ENTER to continue playing.");
textprintf_centre_ex(screen, font, RESOL_X / 2, RESOL_Y / 2 + 40, 255, -1, "Press ESCAPE to leave.");

while((! key[KEY_ENTER]) && (! key[KEY_ESC]))
        rest(15);
install_int_ex(increment_game_spd_counter, BPS_TO_TIMER(50));
install_int_ex(fps_timer,SECS_TO_TIMER(1));
        
if (key[KEY_ENTER]) return 0;
if (key[KEY_ESC]) return 2;
return 0;
}
