#include "all_inc.h"
extern int last_fps, cyclecount, nb_fps_cycles;

int fill_data()
{
set_color_conversion(COLORCONV_TOTAL | COLORCONV_KEEP_TRANS);
perso->xsize = 60;
perso->ysize = 101;
perso->refpt.x = (650 -  perso->xsize) / 2; /*center of the screen*/
perso->refpt.y = 350;
perso->energy = 1000; /*kcalories of course*/
perso->max_speed = 15; 
perso->ttl_in_nutella = 300;
perso->sprite = load_bitmap("perso.bmp", NULL);
perso->stomach_left = 50;

flooding_nutella->refpt.x = 1; /*constant*/
flooding_nutella->refpt.y = 10; /*constant*/
flooding_nutella->amount = 200;
flooding_nutella->xsize = 649; /*constant*/
nutella_flow_spd = 16; /*one unit each 16 cycles*/
nutella_flow_delay = 0;

troll_nutella->refpt.x = 700;
troll_nutella->amount = 100;
troll_nutella->refpt.y = 450 - troll_nutella->amount;
troll_nutella->xsize = 90;

troll->time_to_pack = 300;
troll->normal = load_bitmap("troll.bmp", NULL);
troll->happy = load_bitmap("trollcontent.bmp", NULL);
troll->eating = load_bitmap("trollmange.bmp", NULL);
troll->spr = troll->normal;
bucket->capacity = 300;

dump->refpt.x = 523;
dump->refpt.y = 380;
dump->ttl = 150;
dump->active = 1;
dump->sprite = load_bitmap("dump.bmp", NULL);
dump2->refpt.x = 0;
dump2->refpt.y = 380;
dump2->sprite = load_bitmap("dump2.bmp", NULL);
if((dump->message = load_bitmap("feed.bmp", NULL)) == NULL)
        fprintf(stderr, "Sprite feed.bmp couldn't be loaded\n");
        
use_cannon = 0;
cannon->refpt.x = 325;
cannon->refpt.y = 449;
cannon->size = 50;
cannon->angle = 90;
cannon->delay_to_bullet = 300;
cannon->sprite = load_bitmap("cannon.bmp", NULL);

target->refpt.x = 590;
target->refpt.y = 125;
target->ttl = 300;

wave->size = 100;
wave->temp = create_bitmap(wave->size, 10);

bg = load_bitmap("bg.bmp", NULL);
score = 0;
return 0;
}



int main_loop()
{ /*well, this function does pretty much nothing*/
if(! move_everyone())
        return get_keypress(); /*continue running until get_keypress returns non zero*/
else return 5; /*defeated :)*/
}


int move_everyone() /*move the nutella and so on*/
{
round_integer_coordinates(); /*compute the add_x and add_y values*/
troll_nutella->refpt.y = 450 - troll_nutella->amount; /*dirty hack to display troll nutella from bottom to top*/
if (perso->state & MUST_COMPUTE_SPEED)
        { /*if the bucket is being filled or nutella being dumped*/
        compute_player_speed(); /*based upon bucket filling*/
        perso->state &= ~MUST_COMPUTE_SPEED;
        }
if (! bucket->content) /*if the bucket is empty*/
        perso->speed = perso->max_speed;

if (perso->stomach_left < 50 && !(cyclecount % 8))
        perso->stomach_left++;

update_player_diving(); /*decrease player's ttl_in_nutella*/
update_troll_sprite();
troll_uses_nutella();
update_nutella_flow();
update_dump();

if(use_cannon)
        {
        update_target(); /*move the target if necessary and decrease its ttl*/
        update_cannon();
        update_wave();
        }

if(score > 8000)  /*unlock the nutellator*/
        {
        if(use_cannon == 0)
                {
                use_cannon=1;
                cannon_splash();
                }
        }
        
if(perso->energy <= 0 || flooding_nutella->amount >= 435)
        return 1; /*you lost*/
if(score > 32000 && ! game_ended)
        {
        game_ended = 1;
        return victory_screen(); /*you won*/
        }
return 0;
}


int update_wave()
{
if( ! wave->exists)
        return 1;

/*increase the offset (to animate the wave)*/        
wave->offset += 20;

/*move the wave*/
wave->refpt.x += (int)cos(3.14159 * wave->angle/ 180);
wave->refpt.y -= (int)sin(3.14159 * wave->angle / 180);
wave->add_x += (cos(3.14159 * wave->angle / 180) - (int)cos(3.14159 * wave->angle / 180));
wave->add_y -= (sin(3.14159  * wave->angle  / 180) - (int)sin(3.14159 * wave->angle / 180));

if(wave->refpt.x < 50 || wave->refpt.x > 600 || wave->refpt.y < 30)
        wave->exists = 0;

        
/*now check for collision with the target*/
point wave_end = wave->refpt;
wave_end.x += wave->size * cos(3.14159 * wave->angle /180);
wave_end.y -= wave->size * sin(3.14159 * wave->angle /180);

if(abs(target->refpt.x - wave_end.x) < 20 && abs(target->refpt.y - wave_end.y) < 20)
        { /*we hit the target*/
        score += 500; /*score ++*/
        wave->exists = 0; /*the wave disappears*/
        cannon->delay_to_bullet = 30; /*the player can fire again almost immediately*/
        bucket->capacity += 15;
        flooding_nutella->amount = 100;
        troll_nutella->amount += 200;
        perso->energy = 1000;
        if(target->ttl > 50)
                target->ttl = 50;
        } /*that's what people call : jackpot*/
        
if(wave_end.y < (flooding_nutella->amount + flooding_nutella->refpt.y) && !(cyclecount % 3))
        flooding_nutella->amount --;
        
return 0;
}



int update_cannon()
{
if(cannon->delay_to_bullet)
        cannon->delay_to_bullet --;
return 0;
}




int update_dump()
{
if(dump->active)
        dump->ttl--;
else
        dump2->ttl--;
        
if((! dump->ttl) && dump->active)
        {
        dump->active = 0;
        dump2->active = 1;
        dump2->ttl = 400 + (score) % 600;
        }

if((! dump2->ttl) && dump2->active)
        {
        dump2->active = 0;
        dump->active = 1;
        dump->ttl = 400 + (score) % 600;
        }

return 0;
}








int update_target()
{
target->ttl--;
srand(time(NULL) + score);
if(! target->ttl)
        { /*generate another target*/
        target->ttl = rand() % 1000;
        target->refpt.x = 20 + (cyclecount + score + rand()) % 610;
        target->refpt.y = 20 + (cyclecount + score + rand()) % (flooding_nutella->amount - 30);
        }
return 0;
}




int update_nutella_flow()
{

if((cyclecount % 15) == 0) /*regular flow*/
        flooding_nutella->amount ++;
        
if(nutella_flow_delay >= nutella_flow_spd) /*speed flowing*/
        {
        if(nutella_flow_spd > 0)
                {
                nutella_flow_delay = 0;
                flooding_nutella->amount++;
                }
        if(nutella_flow_spd <= 0)
                {
                if(cyclecount % 2) flooding_nutella->amount++;
                }
        }
else nutella_flow_delay ++;

/*calculate the new speed*/
nutella_flow_spd = 16 - (score / 1000); 
if(flooding_nutella->amount < 100) /*"must refill" aka "good player"*/
        flooding_nutella->amount++;

        
if((cyclecount % 5) == 0) /*sine variation (NOT displaying of the wave ! that's different)*/
        flooding_nutella->sine +=  2 * sin(3.141592653589793238462643383279502 * cyclecount / 180);
else
        {
        if(flooding_nutella->sine > 0.5)
                {
                flooding_nutella->amount ++;
                flooding_nutella->sine --;
                }
        if(flooding_nutella->sine < -0.5)
                {
                flooding_nutella->amount--;
                flooding_nutella->sine ++;
                }
        }
        


srand(score + cyclecount);
for(int i = 0; i < 30; i ++)
        { /*update circles*/
        if(flooding_nutella->circles[i].ttl)
                { /*then it exists*/
                /*update it*/
                if(flooding_nutella->circles[i].ttl < 250 && flooding_nutella->circles[i].radius == 5)
                        flooding_nutella->circles[i].radius = 4;
                if(flooding_nutella->circles[i].ttl < 200 && flooding_nutella->circles[i].radius == 4)
                        flooding_nutella->circles[i].radius = 3;
                if(flooding_nutella->circles[i].ttl < 150 && flooding_nutella->circles[i].radius == 3)
                        flooding_nutella->circles[i].radius = 2;
                if(flooding_nutella->circles[i].ttl < 50 && flooding_nutella->circles[i].radius == 2)
                        flooding_nutella->circles[i].radius = 1;
                flooding_nutella->circles[i].ttl --;
               
                }
        else { /*regenerate it*/
                
                flooding_nutella->circles[i].ttl = rand() % 300;
                flooding_nutella->circles[i].pos.x = 5 + rand() % (flooding_nutella->xsize - 10);
                flooding_nutella->circles[i].pos.y = 20 + rand() % (flooding_nutella->amount + 1);
                flooding_nutella->circles[i].radius = rand() % 5;
                }
        }
for(int i = 0; i < 10; i ++)
        { /*update circles*/
        if(troll_nutella->circles[i].ttl)
                { /*then it exists*/
                /*update it*/
                if(troll_nutella->circles[i].ttl < 250 && troll_nutella->circles[i].radius == 5)
                        troll_nutella->circles[i].radius = 4;
                if(troll_nutella->circles[i].ttl < 200 && troll_nutella->circles[i].radius == 4)
                        troll_nutella->circles[i].radius = 3;
                if(troll_nutella->circles[i].ttl < 150 && troll_nutella->circles[i].radius == 3)
                        troll_nutella->circles[i].radius = 2;
                if(troll_nutella->circles[i].ttl < 50 && troll_nutella->circles[i].radius == 2)
                        troll_nutella->circles[i].radius = 1;
                troll_nutella->circles[i].ttl --;
               
                }
        else { /*regenerate it*/
                
                troll_nutella->circles[i].ttl = rand() % 300;
                troll_nutella->circles[i].pos.x = 5 + troll_nutella->refpt.x + rand() % (troll_nutella->xsize - 10);
                troll_nutella->circles[i].pos.y = 15 + rand() % (troll_nutella->amount + 1);
                troll_nutella->circles[i].radius = rand() % 5;
                }
        }
return 0;
}





int update_player_diving()
{
if(is_player_in_nutella())
        { /*bad for him, he may dive*/
        if(perso->ttl_in_nutella > 0)
                perso->ttl_in_nutella --;
        else
                {
                perso->energy -= 7;
                }
        }
else if(perso->ttl_in_nutella <= 297) perso->ttl_in_nutella += 3;

return 0;
}





int troll_uses_nutella()
{
/*the troll eats nutella and uses it to make nutella packs*/
if(troll->time_to_pack == 0 && troll_nutella->amount > 400)
        { /*next level !*/
        troll->time_to_pack = 400;
        troll_nutella->amount -= 333;
        score += 1000;
        bucket->capacity += 20;
        if(use_cannon)
                cannon->delay_to_bullet = 30;
        return 1;
        }
if(troll->time_to_pack > 0)
        troll->time_to_pack --;

int eating_modulo = 1;
if(score < 8000) eating_modulo = (int)7 - score / 2000;
if(score > 8000) eating_modulo = (int)3 - (score - 11000) / 5000;
if (!eating_modulo) eating_modulo = 1;
if(troll_nutella->amount && !(cyclecount % eating_modulo)) troll_nutella->amount --;
return 0;
}




int update_troll_sprite()
{ /*a linked list for 3 sprites would be overkill*/
troll->sprtime ++;

if((troll->spr == troll->normal && troll->sprtime >= 300 && troll_nutella->amount > 100) || (troll_nutella->amount > 400))
        { /*change sprite to "eating"*/
        troll->sprtime = 0;
        troll->spr = troll->eating;
        }
        
if(troll->spr == troll->eating && troll->sprtime >= 300)
        {
        troll->sprtime = 0;
        if(troll_nutella->amount > 100)
                troll->spr = troll->happy;
        else troll->spr = troll->normal;
        }
        
if((troll->spr == troll->happy && troll->sprtime >= 200) || (troll_nutella->amount < 50))
        {
        troll->sprtime = 0;
        troll->spr = troll->normal;
        }
        
return 0;
}

int get_keypress()
{
if (key[KEY_ESC])
        return 1;
        
/*move the player*/
if (key[KEY_UP])
        move_pl_up(perso->speed);
if (key[KEY_DOWN])
        move_pl_down(perso->speed);
if (key[KEY_LEFT])
        move_pl_left(perso->speed);
if (key[KEY_RIGHT])
        move_pl_right(perso->speed);

/*fill the bucket or feed the troll*/
if (key[KEY_SPACE])
        {
        perso->state |= SPACE_PRESSED;
        if(bucket->content < bucket->capacity && is_player_in_nutella() && flooding_nutella->amount > 0 && ! is_player_near_dump() && !(perso->state & DUMPING_NUTELLA))
                {
                perso->state |= FILLING_BUCKET;
                perso->state |= MUST_COMPUTE_SPEED;
                bucket->content ++;
                bucket->time_to_next--;
                if(bucket->time_to_next <= 0)
                        {
                        flooding_nutella->amount--;
                        bucket->time_to_next = 5;
                        }
                
                }
                
        if(is_player_near_dump() && bucket->content > 0 && ! (perso->state & FILLING_BUCKET))
                {
                perso->state |= DUMPING_NUTELLA;
                perso->state |= MUST_COMPUTE_SPEED;
                bucket->content--;
                score++;
                if(troll_nutella->amount < 449)
                        troll_nutella->amount++;

                }
        
        }
else
        {
        perso->state &= ~SPACE_PRESSED;
        perso->state &= ~FILLING_BUCKET;
        perso->state &= ~DUMPING_NUTELLA;
        }

/*eat nutella*/
if (key[KEY_ENTER])
        {
        if(is_player_in_nutella() && flooding_nutella->amount > 0 && perso->stomach_left)
                {
                perso->stomach_left --;
                if(perso->energy < 950)
                        perso->energy += 25;
                else
                        perso->energy = 1000;
                if(perso->state & HAS_EATED_NUTELLA)
                        {
                        flooding_nutella->amount--;
                        perso->state &= ~HAS_EATED_NUTELLA;
                        }
                else
                        {
                        perso->state |= HAS_EATED_NUTELLA;
                        }
                }
        }

        
/*hey, we're encountering a keybindings problem, especially due to my odd Typematrix keyboard*/
/*rotate the Nutellator*/
if (key[KEY_LCONTROL] && cannon->angle < 180)
        cannon->angle++;
if (key[KEY_ALT] && cannon->angle)
        cannon->angle--;
if (key[KEY_LSHIFT] && !cannon->delay_to_bullet)
        fire_wave();
        
if (key[KEY_PAUSE] || key[KEY_P])
        pause();
/*        
if (key[KEY_PLUS_PAD] && !(cyclecount % 5)) 
        {
        ncolor ++;
        printf("Ncolor %i\n", ncolor);
        }
if (key[KEY_MINUS_PAD] && !(cyclecount % 5))
        {
        ncolor --;
        printf("Ncolor %i\n", ncolor);
        }*/
return 0;
}

int pause()
{
remove_int(increment_game_spd_counter);
remove_int(fps_timer);

clear_keybuf();

rectfill(screen, 130, 100, 670, 500, 0);
rect(screen, 130, 100, 670, 500, 255);
textout_centre_ex(screen, font, "GAME PAUSED", RESOL_X / 2, RESOL_Y /3, 255, -1);
textprintf_ex(screen, font, RESOL_X / 3, RESOL_Y / 2 + 100, 255, -1, "Press ENTER.");
while(! key[KEY_ENTER])
        rest(15);
install_int_ex(increment_game_spd_counter, BPS_TO_TIMER(50));
install_int_ex(fps_timer,SECS_TO_TIMER(1));
return 0;
}
