//
// The Lord of the Stars - Copyright (c) 2005 Rodrigo Braz Monteiro
// Rodrigo Braz Monteiro's entry for TINS'05
// This source file is subject to GNU General Public License
// See included license.txt for more information
//
// You can reach the author at:
// http://zeratul.cellosoft.com
// zeratul@cellosoft.com
//

#include <stdlib.h>
#include <string.h>
#include "enemy.h"
#include "wave.h"


// Constructors
EnemyWave::EnemyWave() {
	SpawnCount = 0;
	MidiNumber = -1;
	BirthTime = 0;

	for (int i=0;i<16;i++) EnemyChance[i] = 0;
	EnemyTotal = 0;
	for (int i=0;i<64;i++) name[i] = 0;
	time = -1;
	SpawnMinTime = 0;
	SpawnMaxTime = 0;
}

EnemyWave::EnemyWave(const char* _name) {
	SpawnCount = 0;
	MidiNumber = -1;
	BirthTime = 0;

	for (int i=0;i<16;i++) EnemyChance[i] = 0;
	EnemyTotal = 0;
	for (int i=0;i<64;i++) name[i] = 0;
	time = -1;
	SpawnMinTime = 0;
	SpawnMaxTime = 0;
	strcpy(name,_name);
}


// Returns spawned enemy
Enemy *EnemyWave::SpawnEnemy () {
	EnemyType spawntype = (EnemyType) SpawnEnemyType();
	if (spawntype == -1) return NULL;
	Enemy *EnemyToSpawn;

	switch (spawntype) {
		case ENEMY_ORC:
			EnemyToSpawn = new EnemyOrc;
			break;
		case ENEMY_TROLL:
			EnemyToSpawn = new EnemyTroll;
			break;
		case ENEMY_MINE:
			EnemyToSpawn = new EnemyMine(0);
			break;
		case ENEMY_ASTEROID1:
			EnemyToSpawn = new EnemyMine(1);
			break;
		case ENEMY_ASTEROID2:
			EnemyToSpawn = new EnemyMine(2);
			break;
		case ENEMY_URUK:
			EnemyToSpawn = new EnemyUruk();
			break;
		default:
			EnemyToSpawn = NULL;
			break;
	}

	return EnemyToSpawn;
}


// See if it should spawn an enemy
int EnemyWave::SpawnEnemyType() {
	time--;
	if (BirthTime > 0) BirthTime--;
	if (time > 0) return -1;
	if (time < 0) {
		BirthTime = 300;
		time = (rand() % (SpawnMaxTime-SpawnMinTime+1)) + SpawnMinTime + 100;
		return -1;
	}

	// New time
	time = (rand() % (SpawnMaxTime-SpawnMinTime+1)) + SpawnMinTime;

	// Calculate total odds
	EnemyTotal = 0;
	for (int i=0;i<16;i++) EnemyTotal += EnemyChance[i];

	// Spawncount
	SpawnCount--;

	// Pick a random enemy to spawn
	int pick = rand()%EnemyTotal;
	int cur = 0;
	for (int i=0;i<16;i++) {
		cur += EnemyChance[i];
		if (cur >= pick) return i;
	}

	// Fail
	return -1;
}
