/////////////////
// CODE BY JUSTT
/////////////////
// Written for Lord of the Stars

#include "dialogue.h"

#include <cstdlib>
#include <iostream>
#include <stdio.h>

void Dialog::addEntry(DialogEntry *new_entry)
{
     if(!new_entry) return;
     entry = (DialogEntry**)realloc(entry, (n_entry+1)*sizeof(DialogEntry*));
     entry[n_entry++] = new_entry;
}

void Dialog::flushEntries()
{
     for(int i=0; i < n_entry; i++)
         delete entry[i];
     delete [] entry;
     entry = NULL;
     n_entry = 0;
}

int LoadDialog(const char *filename, Dialog **&dlg_list, int &n_dialog)
{
      if(!filename || &dlg_list == NULL)
            return INVALID_PARAMETERS;
      
      FILE *fp = fopen(filename, "r");
      if(fp)
      {
            {
                int len = strlen(DIALOGSCRIPT_HEADER);
                char *header = new char[len+1];
                fread(header, 1, len, fp);
                if(strncmp(header, DIALOGSCRIPT_HEADER, len) != 0)
                {
                    fclose(fp);
                    return INVALID_FILE;
                }
                fseek(fp, sizeof("\n\n\n"), SEEK_CUR); // Go to the first dialog
            }

            n_dialog = 0;
            Dialog *new_dialog = NULL;
            while(true)
            {                                
                {
                    int len = strlen(DIALOG_HEADER);
                    char *dialog_header = new char[len+1];
                    fread(dialog_header, 1, len, fp);
                    if(strncmp(dialog_header, DIALOG_HEADER, len) != 0)
                        break;
                    
                    new_dialog = new Dialog;
                    fscanf(fp, "%i", &new_dialog->id);
                    fseek(fp, sizeof("\n"), SEEK_CUR); // Go to next line
                }
                
                int i=0;
                char msg[512];
                DialogEntry *new_entry=NULL;
                while(true)
                {
                    char msg_start='\0';
                    fread(&msg_start, 1, 1, fp);
                    if(msg_start != MESSAGE_START)
                        break;
    
                    new_entry = new DialogEntry;
                    fscanf(fp, "%i %i %i", &new_entry->left, &new_entry->right, &new_entry->speaker);
                    msg[0] = '\0';
                    // The dialog scripts must end with a new line!
                    for(i=0; msg[i++] != '\n';)
                        fread(&msg[i], 1, sizeof(char), fp);
                    new_entry->msg = new char [i-2];
                    strncpy(new_entry->msg, msg+2, i-3);
                    new_entry->msg[i-3] = 0;
                    
                    new_dialog->addEntry(new_entry);
                }
                
                dlg_list = (Dialog**)realloc(dlg_list, (n_dialog+1)*sizeof(Dialog*));
                dlg_list[n_dialog] = new_dialog;
                n_dialog++;
            }
            fclose(fp);
            return NO_ERROR;
      }
      else
          // File not found
          return INVALID_FILE;       
};

