//
// The Lord of the Stars - Copyright (c) 2005 Rodrigo Braz Monteiro
// Rodrigo Braz Monteiro's entry for TINS'05
// This source file is subject to GNU General Public License
// See included license.txt for more information
//
// You can reach the author at:
// http://zeratul.cellosoft.com
// zeratul@cellosoft.com
//

#include <allegro.h>
#include <string.h>
#include <stdio.h>
#define ALFONT_DLL
#include <alfont.h>
#include "data.h"
#include "kernel.h"
#include "people.h"
#include "playership.h"
#include "wave.h"
#include "dialogue.h"


// Constructor
DataClass::DataClass() {
	pilot = 1;
	FullScreen = 0;
	ColorDepth = 32;

	Logging = false;
	Log("Data constructor");
}


// Initialize
void DataClass::Init() {
	// Init
	char path[512];

	// Load bmps
	MakePath(path,"img/logo.gif");
	LogoBmp = load_bitmap(path,NULL);

	MakePath(path,"img/playershot.bmp");
	PlayerShotBmp = load_bitmap(path,NULL);
	
	MakePath(path,"img/orcship01.bmp");
	EnemyBmp[0] = load_bitmap(path,NULL);
	MakePath(path,"img/trollship01.bmp");
	EnemyBmp[1] = load_bitmap(path,NULL);
	MakePath(path,"img/mine.bmp");
	EnemyBmp[2] = load_bitmap(path,NULL);
	MakePath(path,"img/asteroid01.bmp");
	EnemyBmp[3] = load_bitmap(path,NULL);
	MakePath(path,"img/asteroid02.bmp");
	EnemyBmp[4] = load_bitmap(path,NULL);
	MakePath(path,"img/urukship01.bmp");
	EnemyBmp[5] = load_bitmap(path,NULL);

	MakePath(path,"img/orcshot.bmp");
	EnemyShotBmp[0] = load_bitmap(path,NULL);
	MakePath(path,"img/trollshot.bmp");
	EnemyShotBmp[1] = load_bitmap(path,NULL);
	
	MakePath(path,"img/dialogue.bmp");
	DialogueBmp = load_bitmap(path,NULL);
	MakePath(path,"img/explosion.bmp");
	ExplosionBmp = load_bitmap(path,NULL);
	MakePath(path,"img/debris.bmp");
	DebrisBmp = load_bitmap(path,NULL);

	// Load samples
	MakePath(path,"snd/cfbeep1.wav");
	Sample[0] = load_sample(path);
	MakePath(path,"snd/shot.wav");
	Sample[1] = load_sample(path);
	MakePath(path,"snd/hit.wav");
	Sample[2] = load_sample(path);
	MakePath(path,"snd/explosion.wav");
	Sample[3] = load_sample(path);
	MakePath(path,"snd/impact.wav");
	Sample[4] = load_sample(path);
	MakePath(path,"snd/beep.wav");
	Sample[5] = load_sample(path);
	MakePath(path,"snd/orcshot.wav");
	Sample[6] = load_sample(path);
	MakePath(path,"snd/trollshot.wav");
	Sample[7] = load_sample(path);
	MakePath(path,"snd/cfbeep2.wav");
	Sample[8] = load_sample(path);

	// Load fonts
	MakePath(path,"ashbbl.ttf");
	Font[0] = alfont_load_font(path);
	alfont_set_font_size(Font[0],24);
	Font[1] = alfont_load_font(path);
	alfont_set_font_size(Font[1],18);
	Font[2] = alfont_load_font(path);
	alfont_set_font_size(Font[2],36);
	Font[3] = alfont_load_font(path);
	alfont_set_font_size(Font[3],30);

	// Load people
	for (int i=0;i<8;i++) Person[i] = NULL;
	Person[0] = new People("Unknown","img/portrait00.gif",makecol(255,255,255));
	Person[1] = new People("F-Rod","img/portrait01.gif",makecol(152,145,238));
	Person[2] = new People("Sammwiss","img/portrait02.gif",makecol(248,150,148));
	Person[3] = new People("Matty","img/portrait03.gif",makecol(148,224,153));
	Person[4] = new People("Bippin","img/portrait04.gif",makecol(242,171,64));
	Person[5] = new People("GIMPli","img/portrait05.gif",makecol(112,69,190));
	Person[6] = new People("LEGO Lash","img/portrait06.gif",makecol(197,197,197));
	Person[7] = new People("King Argon","img/portrait07.gif",makecol(215,255,196));
	Person[8] = new People("Gandalpha","img/portrait08.gif",makecol(153,230,208));
	Person[9] = new People("Dinon","img/portrait09.gif",makecol(184,10,10));

	// Load ships
	for (int i=0;i<8;i++) Ships[i] = NULL;
	// Frodo
	Ships[0] = new PlayerShip("img/playership00.bmp","Stingy");
	Ships[0]->DamageResistance = 0.8;
	Ships[0]->MaxLife = 100;
	Ships[0]->ShieldRechargeRate = 60;
	Ships[0]->Acceleration = 0.3;
	Ships[0]->Damage = 10;
	// Sam
	Ships[1] = new PlayerShip("img/playership01.bmp","Fatso");
	Ships[1]->DamageResistance = 0.82;
	Ships[1]->MaxLife = 120;
	Ships[1]->ShieldRechargeRate = 50;
	Ships[1]->Acceleration = 0.28;
	Ships[1]->Damage = 11;
	// Merry
	Ships[2] = new PlayerShip("img/playership02.bmp","Kurisumasu");
	Ships[2]->DamageResistance = 0.75;
	Ships[2]->MaxLife = 110;
	Ships[2]->ShieldRechargeRate = 90;
	Ships[2]->Acceleration = 0.26;
	Ships[2]->Damage = 14;
	// Pippin
	Ships[3] = new PlayerShip("img/playership03.bmp","Sarge");
	Ships[3]->DamageResistance = 0.9;
	Ships[3]->MaxLife = 85;
	Ships[3]->ShieldRechargeRate = 55;
	Ships[3]->Acceleration = 0.35;
	Ships[3]->Damage = 11;

	// Gimli
	Ships[4] = new PlayerShip("img/playership04.bmp","Mythryl");
	Ships[4]->DamageResistance = 0.5;
	Ships[4]->MaxLife = 115;
	Ships[4]->ShieldRechargeRate = 100;
	Ships[4]->Acceleration = 0.2;
	Ships[4]->Damage = 13;
	// Legolas
	Ships[5] = new PlayerShip("img/playership05.bmp","Dragunov");
	Ships[5]->DamageResistance = 0.95;
	Ships[5]->MaxLife = 100;
	Ships[5]->ShieldRechargeRate = 40;
	Ships[5]->Acceleration = 0.4;
	Ships[5]->Damage = 17;
	// Aragorn
	Ships[6] = new PlayerShip("img/playership06.bmp","Induril");
	Ships[6]->DamageResistance = 0.6;
	Ships[6]->MaxLife = 150;
	Ships[6]->ShieldRechargeRate = 50;
	Ships[6]->Acceleration = 0.26;
	Ships[6]->Damage = 16;
	// Gandalf
	Ships[7] = new PlayerShip("img/playership07.bmp","Mithradar");
	Ships[7]->DamageResistance = 0.7;
	Ships[7]->MaxLife = 100;
	Ships[7]->ShieldRechargeRate = 80;
	Ships[7]->Acceleration = 0.29;
	Ships[7]->Damage = 20;
	// Sauron
	Ships[8] = new PlayerShip("img/playership08.bmp","Bagdah-dur");
	Ships[8]->DamageResistance = 0.5;
	Ships[8]->MaxLife = 150;
	Ships[8]->ShieldRechargeRate = 30;
	Ships[8]->Acceleration = 0.4;
	Ships[8]->Damage = 30;

	// Unlocking
	for (int i=0;i<5;i++) Unlocked[i] = false;
	MakePath(path,"lotsu.dat");
	set_config_file(path);
	UnlockCode[0] = get_config_int("unlock","0",0);
	UnlockCode[1] = get_config_int("unlock","1",0);
	UnlockCode[2] = get_config_int("unlock","2",0);
	UnlockCode[3] = get_config_int("unlock","3",0);
	UnlockCode[4] = get_config_int("unlock","4",0);
	if (UnlockCode[0] == 52614) Unlocked[0] = true;
	if (UnlockCode[1] == 78182) Unlocked[1] = true;
	if (UnlockCode[2] == 15087) Unlocked[2] = true;
	if (UnlockCode[3] == 59872) Unlocked[3] = true;
	if (UnlockCode[4] == 84213) Unlocked[4] = true;

	// Load dialogues
	MakePath(path,"dialogues.dat");
	LoadDialog(path,Dialogue,n_diags);
}


// Makes a path
void DataClass::MakePath(char *path, const char *src) {
	get_executable_name(path,512);
	*get_filename(path) = 0;
	strcat(path,src);
}


// Draws split text
int DataClass::BreakText(const char *text,int x,int y,int len,ALFONT_FONT *tfont,int color) {
	int line = 0;
	char origText[4096];
	char curLine[512];
	char prevLine[512];
	strcpy(origText,text);
	strcpy(curLine,"");
	strcpy(prevLine,"");
	char *cur;
	int height = alfont_text_height(tfont);
	cur = strtok(origText," ");
	bool forcebreak = false;

	do {
		if (cur[0] != '\n') {
			strcat(curLine,cur);
			strcat(curLine," ");
			forcebreak = false;
		}
		else {
			forcebreak = true;
			cur = strtok(NULL," ");
		}
		if (!forcebreak && alfont_text_length(tfont, curLine) <= len) {
			strcpy(prevLine,curLine);
		}
		else {
			alfont_textout_aa_ex(Kernel.BackBuffer, tfont, prevLine, x, y + line*(height), color, -1);
			line++;
			strcpy(curLine,cur);
			strcat(curLine," ");
			strcpy(prevLine,"");
		}
		cur = strtok(NULL," ");
		if (!cur) {
			alfont_textout_aa_ex(Kernel.BackBuffer, tfont, curLine, x, y + line*(height), color, -1);
			line++;
		}
	} while (cur);

	return line;
}


// Log
void DataClass::Log(const char* string) {
	if (Logging) {
		FILE *fp;
		fp = fopen("log.txt","a+");
		fprintf(fp,string);
		fprintf(fp,"\n");
		fclose(fp);
	}
}


// Convert HSV to RGB (formulas taken from wikipedia: http://en.wikipedia.org/wiki/HSV_color_space)
int DataClass::HSVtoRGB(float H,float S,float V) {
	int r,g,b;
	r=g=b=0;

	// Saturation is zero, make grey
	if (S <= 0.001) {
		r = MAX(0,MIN(int(V*255.0),255));
		g = MAX(0,MIN(int(V*255.0),255));
		b = MAX(0,MIN(int(V*255.0),255));
	}

	// Else, calculate color
	else {
		int Hi = int(H/60);
		float f = H/60.0 - float(Hi);
		float p = V*(1-S);
		float q = V*(1-f*S);
		float t = V*(1-(1-f)*S);
		switch (Hi) {
			case 0: 
				r = int(V*255.0);
				g = int(t*255.0);
				b = int(p*255.0);
				break;
			case 1: 
				r = int(q*255.0);
				g = int(V*255.0);
				b = int(p*255.0);
				break;
			case 2:
				r = int(p*255.0);
				g = int(V*255.0);
				b = int(t*255.0);
				break;
			case 3:
				r = int(p*255.0);
				g = int(q*255.0);
				b = int(V*255.0);
				break;
			case 4:
				r = int(t*255.0);
				g = int(p*255.0);
				b = int(V*255.0);
				break;
			case 5:
				r = int(V*255.0);
				g = int(p*255.0);
				b = int(q*255.0);
				break;
		}
	}

	// Return in allegro format
	return makecol(r,g,b);
}


// Unlock player
void DataClass::Unlock(int i) {
	char path[512];
	MakePath(path,"lotsu.dat");
	switch (i) {
		case 0:
			UnlockCode[i] = 52614;
			set_config_int("unlock","0",UnlockCode[i]);
			break;
		case 1:
			UnlockCode[i] = 78182;
			set_config_int("unlock","1",UnlockCode[i]);
			break;
		case 2:
			UnlockCode[i] = 15087;
			set_config_int("unlock","2",UnlockCode[i]);
			break;
		case 3:
			UnlockCode[i] = 59872;
			set_config_int("unlock","3",UnlockCode[i]);
			break;
		case 4:
			UnlockCode[i] = 84213;
			set_config_int("unlock","4",UnlockCode[i]);
			break;
	}
	Unlocked[i] = true;
}

// Unlock next
void DataClass::UnlockNext() {
	for (int i=0;i<5;i++) {
		if (!Unlocked[i]) {
			Unlock(i);
			NewUnlock = i;
			return;
		}
	}
	NewUnlock = -1;
}
